<?php

namespace App\Http\Controllers;

use App\Services\AnnouncementService;
use App\Traits\HasNotifications;

class AnnouncementController extends Controller
{
    use HasNotifications;

    protected $announcementService;

    public function __construct(AnnouncementService $announcementService)
    {
        $this->announcementService = $announcementService;
    }

    public function index()
    {
        return view('announcements.index');
    }

    public function create()
    {
        return view('announcements.create');
    }

    public function edit($announcement_id)
    {
        $announcement = \App\Models\Announcement::where('announcement_id', $announcement_id)->firstOrFail();
        return view('announcements.edit', compact('announcement'));
    }
}