<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\QrCodeService;

class ResultController extends Controller
{
    public function byStudent()
    {
        return view('results.by-student');
    }

    public function byClass()
    {
        return view('results.by-class');
    }

    public function bySubject()
    {
        return view('results.by-subject');
    }

    public function approval()
    {
        // Check if user can approve results based on settings
        if (!auth()->user()->canApproveResults()) {
            abort(403, 'You do not have permission to approve results.');
        }
        
        return view('results.approval');
    }

    public function annualApproval()
    {
        // Check if user can approve results based on settings
        if (!auth()->user()->canApproveResults()) {
            abort(403, 'You do not have permission to approve results.');
        }
        
        return view('results.annual-approval');
    }

    public function viewAnnualResults()
    {
        return view('results.view-annual-results');
    }

    public function masterList()
    {
        return view('results.master-list');
    }

    public function viewResults()
    {
        // Test if basic view works first
        // return view('results.view-results-test');
        return view('results.view-results');
    }

    public function viewStudentResult($student, $session)
    {
        try {
            $studentRecord = \App\Models\User::where('student_id', $student)->first();
            if (!$studentRecord) {
                abort(404, 'Student not found');
            }
            
            $sessionRecord = \App\Models\SchoolSession::where('slug', $session)->first();
            if (!$sessionRecord) {
                abort(404, 'Session not found');
            }
            
            $viewResultsService = new \App\Services\ViewResultsService();
            $data = $viewResultsService->getStudentCompleteResult($studentRecord->id, $sessionRecord->id);
            
            if (!$data) {
                abort(404, 'Student result not found');
            }
            
            $qrCode = null;
            if ($data['approval']) {
                $qrCodeService = new QrCodeService();
                $currentUrl = request()->url();
                $qrCode = $qrCodeService->generateResultQrCode($data['student'], $data['approval'], $data['session'], $currentUrl);
            }
            
            return view('results.student-result', compact('data', 'qrCode'));
        } catch (\Exception $e) {
            return response()->view('errors.500', ['message' => $e->getMessage()], 500);
        }
    }

    public function printStudentResult($student, $session)
    {
        try {
            $studentRecord = \App\Models\User::find($student);
            if (!$studentRecord) {
                abort(404, 'Student not found');
            }
            
            $sessionRecord = \App\Models\SchoolSession::where('slug', $session)->first();
            if (!$sessionRecord) {
                abort(404, 'Session not found');
            }
            
            $viewResultsService = new \App\Services\ViewResultsService();
            $data = $viewResultsService->getStudentCompleteResult($studentRecord->id, $sessionRecord->id);
            
            if (!$data) {
                abort(404, 'Student result not found');
            }
            
            $qrCode = null;
            if ($data['approval']) {
                $qrCodeService = new QrCodeService();
                $currentUrl = request()->url();
                $qrCode = $qrCodeService->generateResultQrCode($data['student'], $data['approval'], $data['session'], $currentUrl);
            }
            
            return view('results.student-result', compact('data', 'qrCode'));
        } catch (\Exception $e) {
            return response()->view('errors.500', ['message' => $e->getMessage()], 500);
        }
    }

    public function annualResults()
    {
        return view('results.annual-results');
    }

    public function annualMasterList()
    {
        return view('results.annual-master-list');
    }

    public function studentAnnualResult()
    {
        return view('results.student-annual-result');
    }

    public function printStudentAnnualResult($studentId, $year)
    {
        $student = \App\Models\User::where('student_id', $studentId)->first();
        if (!$student) {
            abort(404, 'Student not found');
        }
        
        $annualResultService = new \App\Services\AnnualResultService();
        $data = $annualResultService->getStudentAnnualResultForPrint($student->id, $year);
        
        if (!$data) {
            abort(404, 'Student annual result not found');
        }
        
        $qrCodeService = new QrCodeService();
        $currentUrl = request()->url();
        $qrCode = $qrCodeService->generateAnnualResultQrCode($data['student'], $data['year'], $currentUrl);
        
        return view('results.print-student-annual-result', compact('data', 'qrCode'));
    }

    public function printClassAnnualResult($classId, $year, $batchId = null)
    {
        $annualResultService = new \App\Services\AnnualResultService();
        $data = $annualResultService->getAnnualResultData($year, $classId, $batchId);
        
        if (!$data) {
            abort(404, 'Class annual result not found');
        }
        
        $qrCodeService = new QrCodeService();
        $currentUrl = request()->url();
        $qrCode = $qrCodeService->generateClassAnnualResultQrCode($data['class'], $data['year'], $currentUrl, $data['batch']);
        
        return view('results.print-class-annual-result', compact('data', 'qrCode'));
    }

    public function printAnnualMasterList($classId, $year, $batchId = null)
    {
        $annualResultService = new \App\Services\AnnualResultService();
        $data = $annualResultService->getAnnualMasterListData($year, $classId, $batchId);
        
        if (!$data) {
            abort(404, 'Annual master list not found');
        }
        
        $qrCodeService = new QrCodeService();
        $currentUrl = request()->url();
        $qrCode = $qrCodeService->generateAnnualMasterListQrCode($data['class'], $data['year'], $currentUrl, $data['batch']);
        
        return view('results.print-annual-master-list', compact('data', 'qrCode'));
    }

    public function printMasterList($sessionId, $classId, $batchId = null)
    {
        if ($batchId === 'all') {
            $batchId = null;
        }
        
        $masterListService = new \App\Services\MasterListService();
        $data = $masterListService->getMasterListData($sessionId, $classId, $batchId);
        
        if (!$data) {
            abort(404, 'Master list not found');
        }
        
        $qrCodeService = new QrCodeService();
        $currentUrl = request()->url();
        $qrCode = $qrCodeService->generateMasterListQrCode($data['session'], $data['class'], $currentUrl, $data['batch']);
        
        return view('results.print-master-list', compact('data', 'qrCode'));
    }
    
    public function offlineUpload()
    {
        return view('results.offline-upload');
    }
}