<?php

namespace App\Http\Controllers;

use App\Models\SchoolClass;
use App\Services\SchoolClassService;
use App\Traits\HasNotifications;
use Illuminate\Http\Request;

class SchoolClassController extends Controller
{
    use HasNotifications;

    public function __construct(private SchoolClassService $schoolClassService)
    {
    }

    public function index()
    {
        return view('school-classes.index');
    }

    public function create()
    {
        return view('school-classes.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:school_classes,name',
            'alias' => 'nullable|string|max:50',
            'description' => 'nullable|string|max:500',
            'is_active' => 'boolean'
        ]);

        $this->schoolClassService->create($request->all());

        session()->flash('toast', [
            'type' => 'success',
            'message' => 'Class created successfully!'
        ]);

        return redirect()->route('school-classes.index');
    }

    public function show(SchoolClass $schoolClass)
    {
        return view('school-classes.show', compact('schoolClass'));
    }

    public function edit(SchoolClass $schoolClass)
    {
        return view('school-classes.edit', compact('schoolClass'));
    }

    public function update(Request $request, SchoolClass $schoolClass)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:school_classes,name,' . $schoolClass->id,
            'alias' => 'nullable|string|max:50',
            'description' => 'nullable|string|max:500',
            'is_active' => 'boolean'
        ]);

        $this->schoolClassService->update($schoolClass, $request->all());

        session()->flash('toast', [
            'type' => 'success',
            'message' => 'Class updated successfully!'
        ]);

        return redirect()->route('school-classes.index');
    }


    public function reorder()
    {
        return view('school-classes.reorder');
    }
}
