<?php

namespace App\Http\Controllers;

use App\Models\SchoolSession;
use App\Services\SchoolSessionService;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class SchoolSessionController extends Controller
{
    public function __construct(
        private SchoolSessionService $sessionService
    )
    {
    }

    public function index(): View
    {
        $sessions = $this->sessionService->getAllSessions();
        return view('school-sessions.index', compact('sessions'));
    }

    public function create(): View
    {
        return view('school-sessions.create');
    }

    public function show(SchoolSession $schoolSession): View
    {
        return view('school-sessions.show', compact('schoolSession'));
    }

    public function edit($slug): View
    {
        $schoolSession = SchoolSession::where('slug', $slug)->firstOrFail();
        return view('school-sessions.edit', compact('schoolSession'));
    }

}
