<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Services\AnnouncementService;
use App\Traits\HasNotifications;
use App\Models\Announcement;

class AnnouncementsTable extends Component
{
    use WithPagination, HasNotifications;

    public $search = '';

    protected $announcementService;

    public function boot(AnnouncementService $announcementService)
    {
        $this->announcementService = $announcementService;
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function deleteAnnouncement($announcementId)
    {
        try {
            $announcement = Announcement::where('announcement_id', $announcementId)->firstOrFail();
            $this->announcementService->deleteAnnouncement($announcement);
            
            session()->flash('toast', [
                'type' => 'success',
                'message' => 'Announcement deleted successfully!'
            ]);
        } catch (\Exception $e) {
            session()->flash('toast', [
                'type' => 'error',
                'message' => 'Failed to delete announcement: ' . $e->getMessage()
            ]);
        }
    }
    
    public function toggleActive($announcementId)
    {
        try {
            $announcement = Announcement::where('announcement_id', $announcementId)->firstOrFail();
            $announcement->update(['active' => !$announcement->active]);
            
            $status = $announcement->active ? 'activated' : 'deactivated';
            session()->flash('toast', [
                'type' => 'success',
                'message' => "Announcement {$status} successfully!"
            ]);
        } catch (\Exception $e) {
            session()->flash('toast', [
                'type' => 'error',
                'message' => 'Failed to update announcement: ' . $e->getMessage()
            ]);
        }
    }

    public function render()
    {
        $announcements = Announcement::with('creator')
            ->whereNull('deleted_at')
            ->when($this->search, function ($query) {
                $query->where('title', 'like', '%' . $this->search . '%')
                      ->orWhere('message', 'like', '%' . $this->search . '%');
            })
            ->orderBy('created_at', 'desc')
            ->paginate(15);

        return view('livewire.announcements-table', compact('announcements'));
    }
}