<?php

namespace App\Livewire;

use Livewire\Component;
use App\Services\AnnouncementService;

class DashboardAnnouncements extends Component
{
    public $popupAnnouncements = [];
    public $fixedAnnouncements = [];

    protected $announcementService;

    public function boot(AnnouncementService $announcementService)
    {
        $this->announcementService = $announcementService;
    }

    public function mount()
    {
        try {
            $announcements = $this->announcementService->getAnnouncementsForUser(auth()->user());
            
            $this->popupAnnouncements = $announcements->where('type', 'popup')->values()->toArray();
            $this->fixedAnnouncements = $announcements->where('type', 'fixed')->values()->toArray();
        } catch (\Exception $e) {
            $this->popupAnnouncements = [];
            $this->fixedAnnouncements = [];
        }
    }

    public function dismissAnnouncement($announcementId)
    {
        // Client-side dismissal handled by JavaScript sessionStorage
        // This method is kept for compatibility but does nothing server-side
    }

    public function render()
    {
        return view('livewire.dashboard-announcements');
    }
    

}