<?php

namespace App\Livewire\Results;

use Livewire\Component;
use App\Services\AnnualResultService;
use App\Models\User;
use App\Traits\HasNotifications;

class StudentAnnualResult extends Component
{
    use HasNotifications;

    public $studentId;
    public $year;
    public $classId;
    public $batchId;
    public $students = [];
    public $classes = [];
    public $batches = [];
    public $years = [];
    public $studentData = [];
    public $subjects = [];
    public $sessions = [];
    public $selectedStudent;
    public $selectedYear;
    public $selectedClass;
    public $teachers = [];
    public $annualApproval;

    protected $annualResultService;

    public function boot(AnnualResultService $annualResultService)
    {
        $this->annualResultService = $annualResultService;
    }

    public function mount()
    {
        $this->classes = $this->annualResultService->getClassesForUser(auth()->user());
        $this->years = $this->annualResultService->getAvailableYears();
    }

    public function updatedClassId()
    {
        $this->batchId = null;
        $this->studentId = null;
        $this->batches = [];
        $this->students = [];
        $this->studentData = [];

        if ($this->classId) {
            $this->batches = \App\Models\Batch::where('school_class_id', $this->classId)
                ->where('is_active', true)
                ->orderBy('name')
                ->get();
        }
    }

    public function updatedBatchId()
    {
        $this->studentId = null;
        $this->students = [];
        $this->studentData = [];

        if ($this->batchId) {
            $this->students = User::where('batch_id', $this->batchId)
                ->where('active', true)
                ->whereDoesntHave('roles')
                ->orderBy('firstname')
                ->get();
        }
    }

    public function loadStudentAnnualResult()
    {
        if (!$this->studentId || !$this->year) {
            $this->showError('Please select student and year');
            return;
        }

        $data = $this->annualResultService->getStudentAnnualResult($this->studentId, $this->year);

        if (!$data) {
            $this->showError('No data found for the selected student and year');
            return;
        }

        $this->studentData = $data['studentData'];
        $this->subjects = $data['subjects'];
        $this->sessions = $data['sessions'];
        $this->selectedStudent = $data['student'];
        $this->selectedYear = $data['year'];
        $this->selectedClass = $data['class'];
        $this->teachers = $data['teachers'];
        
        // Get annual approval data
        $this->annualApproval = \App\Models\AnnualResultApproval::where('student_id', $this->studentId)
            ->where('year', $this->year)
            ->first();

        $this->showSuccess('Student annual result loaded successfully');
        $this->dispatch('initStudentGradeChart', $this->getChartData());
    }

    private function getChartData()
    {
        if (empty($this->studentData)) {
            return [];
        }

        $labels = ['A', 'B', 'C', 'D', 'E', 'F'];
        $data = [
            $this->studentData['annual_grades']['A'],
            $this->studentData['annual_grades']['B'],
            $this->studentData['annual_grades']['C'],
            $this->studentData['annual_grades']['D'],
            $this->studentData['annual_grades']['E'],
            $this->studentData['annual_grades']['F']
        ];

        return [
            'labels' => $labels,
            'data' => $data
        ];
    }



    public function render()
    {
        return view('livewire.results.student-annual-result');
    }
}