<?php

namespace App\Livewire\Settings;

use App\Models\Setting;
use App\Traits\HasNotifications;
use Livewire\Component;

class ResultSettings extends Component
{
    use HasNotifications;

    public $showClassTeachersOnPrint;
    public $showClassTeachersOnline;
    public $showTimestamp;
    public $allowTeacherResultUpload;
    public $allowAdminResultUpload;
    public $allowTeacherEditApprovedResults;
    public $allowAdminEditApprovedResults;
    public $allowHeadTeacherEditApprovedResults;
    public $allowTeacherUnapproveResults;
    public $allowAdminUnapproveResults;
    public $allowHeadTeacherUnapproveResults;
    public $allowTeacherApproveResults;
    public $allowHeadTeacherApproveResults;
    public $allowAdminApproveResults;

    public function mount()
    {
        $this->showClassTeachersOnPrint = Setting::get('show_class_teachers_on_print', true);
        $this->showClassTeachersOnline = Setting::get('show_class_teachers_online', true);
        $this->showTimestamp = Setting::get('show_timestamp', true);
        $this->allowTeacherResultUpload = Setting::get('allow_teacher_result_upload', true);
        $this->allowAdminResultUpload = Setting::get('allow_admin_result_upload', true);
        $this->allowTeacherEditApprovedResults = Setting::get('allow_teacher_edit_approved_results', false);
        $this->allowAdminEditApprovedResults = Setting::get('allow_admin_edit_approved_results', false);
        $this->allowHeadTeacherEditApprovedResults = Setting::get('allow_head_teacher_edit_approved_results', false);
        $this->allowTeacherUnapproveResults = Setting::get('allow_teacher_unapprove_results', false);
        $this->allowAdminUnapproveResults = Setting::get('allow_admin_unapprove_results', false);
        $this->allowHeadTeacherUnapproveResults = Setting::get('allow_head_teacher_unapprove_results', false);
        $this->allowTeacherApproveResults = Setting::get('allow_teacher_approve_results', false);
        $this->allowHeadTeacherApproveResults = Setting::get('allow_head_teacher_approve_results', true);
        $this->allowAdminApproveResults = Setting::get('allow_admin_approve_results', true);
    }

    public function save()
    {
        try {
            Setting::set('show_class_teachers_on_print', $this->showClassTeachersOnPrint);
            Setting::set('show_class_teachers_online', $this->showClassTeachersOnline);
            Setting::set('show_timestamp', $this->showTimestamp);
            Setting::set('allow_teacher_result_upload', $this->allowTeacherResultUpload);
            Setting::set('allow_admin_result_upload', $this->allowAdminResultUpload);
            Setting::set('allow_teacher_edit_approved_results', $this->allowTeacherEditApprovedResults);
            Setting::set('allow_admin_edit_approved_results', $this->allowAdminEditApprovedResults);
            Setting::set('allow_head_teacher_edit_approved_results', $this->allowHeadTeacherEditApprovedResults);
            Setting::set('allow_teacher_unapprove_results', $this->allowTeacherUnapproveResults);
            Setting::set('allow_admin_unapprove_results', $this->allowAdminUnapproveResults);
            Setting::set('allow_head_teacher_unapprove_results', $this->allowHeadTeacherUnapproveResults);
            Setting::set('allow_teacher_approve_results', $this->allowTeacherApproveResults);
            Setting::set('allow_head_teacher_approve_results', $this->allowHeadTeacherApproveResults);
            Setting::set('allow_admin_approve_results', $this->allowAdminApproveResults);

            $this->showToast('success', 'Result settings updated successfully!', 'Settings Updated');
        } catch (\Exception $e) {
            $this->showToast('error', 'Error: ' . $e->getMessage(), 'Settings Error');
        }
    }

    public function render()
    {
        return view('livewire.settings.result-settings');
    }
}