<?php

namespace App\Livewire\Settings;

use App\Models\Setting;
use App\Traits\HasNotifications;
use Livewire\Component;

class SchoolOfficials extends Component
{
    use HasNotifications;

    public $proprietorName;
    public $headTeacherName;
    public $showProprietorSignature;
    public $showHeadTeacherSignature;
    public $signatureType; // 'proprietor', 'head_teacher', or 'both'

    public function mount()
    {
        $this->proprietorName = Setting::get('proprietor_name', 'School Proprietor');
        $this->headTeacherName = Setting::get('head_teacher_name', 'Head Teacher');
        $this->showProprietorSignature = Setting::get('show_proprietor_signature', false);
        $this->showHeadTeacherSignature = Setting::get('show_head_teacher_signature', true);
        $this->signatureType = Setting::get('signature_type', 'head_teacher');
    }

    public function save()
    {
        $this->validate([
            'proprietorName' => 'required|string|max:255',
            'headTeacherName' => 'required|string|max:255',
            'signatureType' => 'required|in:proprietor,head_teacher,both'
        ]);

        try {
            Setting::set('proprietor_name', $this->proprietorName);
            Setting::set('head_teacher_name', $this->headTeacherName);
            Setting::set('show_proprietor_signature', $this->showProprietorSignature);
            Setting::set('show_head_teacher_signature', $this->showHeadTeacherSignature);
            Setting::set('signature_type', $this->signatureType);

            $this->showToast('success', 'School officials settings updated successfully!', 'Settings Updated');
        } catch (\Exception $e) {
            $this->showToast('error', 'Error: ' . $e->getMessage(), 'Settings Error');
        }
    }

    public function render()
    {
        return view('livewire.settings.school-officials');
    }
}