<?php

namespace App\Livewire\Staff;

use Livewire\Component;
use Illuminate\Support\Facades\Hash;
use App\Traits\HasNotifications;

class ChangePasswordForm extends Component
{
    use HasNotifications;

    public $current_password;
    public $new_password;
    public $new_password_confirmation;

    protected $rules = [
        'current_password' => 'required',
        'new_password' => 'required|min:8|confirmed',
    ];

    public function changePassword()
    {
        $this->validate();

        $user = auth()->user();

        if (!Hash::check($this->current_password, $user->password)) {
            $this->showToast('error', 'Current password is incorrect.', 'Error');
            return;
        }

        $user->update([
            'password' => Hash::make($this->new_password)
        ]);

        $this->reset(['current_password', 'new_password', 'new_password_confirmation']);
        
        $this->showToast('success', 'Password changed successfully.', 'Success');
    }

    public function render()
    {
        return view('livewire.staff.change-password-form');
    }
}
