<?php

namespace App\Livewire;

use App\Models\User;
use Livewire\Component;

class StaffProfile extends Component
{
    public $staff;
    public $username;

    public function mount($username)
    {
        $this->username = $username;
        $this->staff = User::with(['roles', 'country', 'state', 'city', 'classes'])
            ->where('username', $username)
            ->firstOrFail();
    }

    public function render()
    {
        return view('livewire.staff-profile');
    }
}