<?php

namespace App\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Services\PayrollService;
use Illuminate\Support\Facades\Auth;

class StaffSalaryDashboard extends Component
{
    use WithPagination;

    public function render()
    {
        $setting = \App\Models\Setting::where('key', 'allow_staff_salary_view')->first();
        $allowView = $setting ? (bool) $setting->value : true;
        
        if (!$allowView && !auth()->user()->can('manage-payments')) {
            return view('livewire.staff-salary-dashboard-disabled');
        }
        
        $user = Auth::user();
        $payrollService = new PayrollService();
        
        $salaryHistories = $payrollService->getSalaryHistoryForUser($user, 10);
        
        return view('livewire.staff-salary-dashboard', compact('salaryHistories'));
    }
}