<?php

namespace App\Livewire\Student;

use Livewire\Component;
use App\Traits\HasNotifications;
use App\Models\SchoolSession;

class StudentAnnualResults extends Component
{
    use HasNotifications;

    public function render()
    {
        $student = auth()->user();
        $years = \App\Models\AnnualResultApproval::where('student_id', $student->id)
            ->pluck('year')
            ->unique()
            ->sort()
            ->reverse()
            ->values();

        return view('livewire.student.student-annual-results', compact('years'));
    }
}