<?php

namespace App\Livewire\Student;

use Livewire\Component;
use App\Traits\HasNotifications;
use App\Models\PaymentRequest;
use App\Models\Setting;

class StudentMakePayment extends Component
{
    use HasNotifications;

    public $paymentRequestId;
    public $paymentRequest;
    public $accountDetails;

    public function mount($paymentRequestId)
    {
        $this->paymentRequestId = $paymentRequestId;
        $this->paymentRequest = PaymentRequest::findOrFail($paymentRequestId);
        
        // Check if this payment request belongs to the authenticated student
        if ($this->paymentRequest->student_id !== auth()->id()) {
            abort(403, 'Unauthorized access to payment request.');
        }
        
        $this->accountDetails = Setting::where('key', 'account_details')->first()?->value;
        if ($this->accountDetails) {
            $this->accountDetails = json_decode($this->accountDetails, true);
        }
    }

    public function confirmPayment()
    {
        $this->showConfirmation(
            'Confirm Payment',
            'Have you completed the payment transfer? This will mark your payment as processing.',
            'Yes, I have paid',
            'markAsProcessing'
        );
    }

    public function markAsProcessing()
    {
        $this->paymentRequest->update(['status' => 'processing']);
        
        session()->flash('toast', [
            'type' => 'success',
            'message' => 'Payment marked as processing. We will verify and update the status shortly.',
            'title' => 'Payment Submitted'
        ]);
        
        return redirect()->route('student.payments.index');
    }

    public function render()
    {
        return view('livewire.student.student-make-payment');
    }
}