<?php

namespace App\Livewire;

use App\Services\SubjectService;
use App\Traits\HasNotifications;
use Livewire\Component;

class SubjectForm extends Component
{
    use HasNotifications;

    public $name = '';

    protected $rules = [
        'name' => 'required|string|max:255|unique:subjects,name'
    ];

    protected $subjectService;

    public function boot(SubjectService $subjectService)
    {
        $this->subjectService = $subjectService;
    }

    public function save()
    {
        $this->validate();
        
        $this->subjectService->createSubject(['name' => $this->name]);
        
        $this->reset('name');
        session()->flash('toast', ['type' => 'success', 'message' => 'Subject created successfully!']);
        
        return redirect()->route('subjects.index');
    }

    public function render()
    {
        return view('livewire.subject-form');
    }
}
