<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Result extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'student_id',
        'session_id',
        'subject_id',
        'ca_score',
        'exam_score',
        'ca_absent',
        'exam_absent',
        'approved',
        'approved_at',
        'approved_by',
    ];

    protected $casts = [
        'ca_score' => 'decimal:2',
        'exam_score' => 'decimal:2',
        'total_score' => 'decimal:2',
        'ca_absent' => 'boolean',
        'exam_absent' => 'boolean',
        'approved' => 'boolean',
        'approved_at' => 'datetime',
    ];

    public function student()
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function session()
    {
        return $this->belongsTo(SchoolSession::class, 'session_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function getTotalScoreAttribute()
    {
        return $this->ca_score + $this->exam_score;
    }

    public function scopeApproved($query)
    {
        return $query->where('approved', true);
    }

    public function scopeUnapproved($query)
    {
        return $query->where('approved', false);
    }

    public function getCaScoreAttribute($value)
    {
        return intval($value);
    }

    public function getExamScoreAttribute($value)
    {
        return intval($value);
    }
}
