<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ResultApproval extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'student_id',
        'session_id',
        'punctuality',
        'mental_alertness',
        'attentiveness',
        'respect',
        'neatness',
        'politeness',
        'honesty',
        'relationship_with_peers',
        'attitude_to_school',
        'teamwork',
        'completes_school_work_promptly',
        'reading',
        'verbal_fluency_diction',
        'handwriting',
        'musical_skills',
        'creative_arts',
        'physical_education',
        'general_reasoning',
        'principal_remarks',
        'approved_by',
        'subjects_snapshot',
        'class_snapshot',
        'annual_pass_percentage',
        'approval_log',
    ];

    protected $casts = [
        'punctuality' => 'decimal:1',
        'mental_alertness' => 'decimal:1',
        'attentiveness' => 'decimal:1',
        'respect' => 'decimal:1',
        'neatness' => 'decimal:1',
        'politeness' => 'decimal:1',
        'honesty' => 'decimal:1',
        'relationship_with_peers' => 'decimal:1',
        'attitude_to_school' => 'decimal:1',
        'teamwork' => 'decimal:1',
        'completes_school_work_promptly' => 'decimal:1',
        'reading' => 'decimal:1',
        'verbal_fluency_diction' => 'decimal:1',
        'handwriting' => 'decimal:1',
        'musical_skills' => 'decimal:1',
        'creative_arts' => 'decimal:1',
        'physical_education' => 'decimal:1',
        'general_reasoning' => 'decimal:1',
        'subjects_snapshot' => 'array',
        'class_snapshot' => 'array',
        'approval_log' => 'array',
        'annual_pass_percentage' => 'decimal:2',
    ];

    public function student()
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function session()
    {
        return $this->belongsTo(SchoolSession::class, 'session_id');
    }

    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function logApprovalAction($action, $userId, $userName)
    {
        $log = $this->approval_log ?? [];
        $log[] = [
            'action' => $action,
            'user_id' => $userId,
            'user_name' => $userName,
            'timestamp' => now()->toISOString(),
        ];
        $this->approval_log = $log;
        $this->save();
    }
    
    public function initializeApprovalLog()
    {
        if (is_null($this->approval_log)) {
            $this->approval_log = [];
        }
    }

    public function getApprovedSubjects()
    {
        return $this->subjects_snapshot ?? [];
    }
}
