<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalaryAdjustment extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'salary_history_id',
        'type',
        'amount',
        'reason',
    ];

    protected $casts = [
        'amount' => 'decimal:0',
    ];

    public function salaryHistory()
    {
        return $this->belongsTo(SalaryHistory::class);
    }

    public function getFormattedAmountAttribute()
    {
        return number_format($this->amount, 0);
    }

    public function getAmountAttribute($value)
    {
        return (int)$value;
    }
}
