<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalaryHistory extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'monthly_salary',
        'net_salary',
        'month',
        'year',
        'status',
        'paid_at',
        'meta'
    ];

    protected $casts = [
        'monthly_salary' => 'decimal:0',
        'net_salary' => 'decimal:0',
        'paid_at' => 'datetime',
        'meta' => 'array'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function adjustments()
    {
        return $this->hasMany(SalaryAdjustment::class);
    }

    public function bonuses()
    {
        return $this->adjustments()->where('type', 'bonus');
    }

    public function deductions()
    {
        return $this->adjustments()->where('type', 'deduction');
    }

    public function getTotalBonusAttribute()
    {
        return (float)$this->bonuses()->sum('amount') ?: 0;
    }

    public function getTotalDeductionsAttribute()
    {
        return (float)$this->deductions()->sum('amount') ?: 0;
    }

    public function getFormattedNetSalaryAttribute()
    {
        return number_format($this->net_salary, 0);
    }

    public function getMonthlySalaryAttribute($value)
    {
        return (int)$value;
    }

    public function getNetSalaryAttribute($value)
    {
        return (int)$value;
    }

    public function getMonthYearAttribute()
    {
        return $this->month . ' ' . $this->year;
    }

    public function updateNetSalary()
    {
        $this->net_salary = $this->monthly_salary + $this->total_bonus - $this->total_deductions;
        $this->save();
    }
}
