<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Cache;

class SchoolClass extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'name',
        'alias',
        'description',
        'is_active',
        'order'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'order' => 'integer'
    ];

    public function batches()
    {
        return $this->hasMany(Batch::class);
    }

    public function teachers()
    {
        return $this->belongsToMany(User::class, 'teacher_classes');
    }

    public function subjects()
    {
        return $this->belongsToMany(Subject::class, 'subject_aliases')
                    ->withPivot('alias')
                    ->withTimestamps();
    }

    public function subjectAliases()
    {
        return $this->hasMany(SubjectAlias::class, 'school_class_id');
    }

    public function getDisplayNameAttribute()
    {
        return $this->alias ?: $this->name;
    }

    /**
     * Boot method to handle model events
     */
    protected static function boot()
    {
        parent::boot();

        static::created(function () {
            Cache::forget('total_classes_count');
        });

        static::updated(function () {
            Cache::forget('total_classes_count');
        });

        static::deleted(function () {
            Cache::forget('total_classes_count');
        });
    }
}
