<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subject extends Model
{
    use SoftDeletes;

    protected $fillable = ['name'];

    public function schoolClasses()
    {
        return $this->belongsToMany(SchoolClass::class, 'subject_aliases')
                    ->withPivot('alias')
                    ->withTimestamps();
    }

    public function aliases()
    {
        return $this->hasMany(SubjectAlias::class);
    }

    public function getNameAttribute($value)
    {
        return str_contains($value, '.') ? strtoupper($value) : ucwords(strtolower($value));
    }

    public function getDisplayNameAttribute()
    {
        $alias = null;
        
        if (isset($this->pivot) && isset($this->pivot->alias)) {
            $alias = $this->pivot->alias;
        }
        
        $name = $alias ?: $this->attributes['name'];
        
        return str_contains($name, '.') ? strtoupper($name) : ucwords(strtolower($name));
    }
}
