<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Role-based Gates
        Gate::define('admin', fn($user) => $user->isAdmin());
        Gate::define('bursar', fn($user) => $user->isBursar() || $user->isAdmin());
        Gate::define('head-teacher', fn($user) => $user->isHeadTeacher() || $user->isAdmin());
        Gate::define('teacher', fn($user) => $user->isTeacher() || $user->isHeadTeacher() || $user->isAdmin());
        Gate::define('student', fn($user) => $user->isStudent() || $user->isAdmin());

        // Permission-based Gates
        Gate::define('manage-payments', fn($user) => $user->hasPermission('manage_payments') || $user->hasPermission('*'));
        Gate::define('manage-students', fn($user) => $user->hasPermission('manage_students') || $user->hasPermission('*'));
        Gate::define('manage-teachers', fn($user) => $user->hasPermission('manage_teachers') || $user->hasPermission('*'));
        Gate::define('manage-results', fn($user) => $user->hasPermission('manage_results') || $user->hasPermission('manage_own_results') || $user->hasPermission('*'));
        Gate::define('manage-attendance', fn($user) => $user->hasPermission('manage_attendance') || $user->hasPermission('manage_own_attendance') || $user->hasPermission('*'));
        Gate::define('approve-results', fn($user) => $user->canApproveResults());
    }
}
