<?php

namespace App\Services;

use SimpleSoftwareIO\QrCode\Facades\QrCode;

class QrCodeService
{
    public function generateResultQrCode($student, $approval, $session, $currentUrl = null): string
    {
        $data = [
            'student_id' => $student->student_id,
            'student_name' => $student->name,
            'approval_date' => $approval->created_at->format('Y-m-d'),
            'approved_by' => $approval->approvedBy->name ?? 'System',
            'session' => $session->name . ' ' . $session->start_year . '/' . $session->end_year,
            'school' => config('app.name'),
            'result_url' => $currentUrl
        ];

        return QrCode::size(120)
            ->format('svg')
            ->generate(json_encode($data));
    }

    public function generateCustomQrCode(array $data, int $size = 100): string
    {
        return QrCode::size($size)
            ->format('svg')
            ->generate(json_encode($data));
    }

    public function generateTextQrCode(string $text, int $size = 100): string
    {
        return QrCode::size($size)
            ->format('svg')
            ->generate($text);
    }

    public function generateAnnualResultQrCode($student, $year, $currentUrl = null): string
    {
        $data = [
            'student_id' => $student->student_id,
            'student_name' => $student->name,
            'academic_year' => $year . '/' . ($year + 1),
            'result_type' => 'Annual Result',
            'school' => config('app.name'),
            'result_url' => $currentUrl
        ];

        return QrCode::size(120)
            ->format('svg')
            ->generate(json_encode($data));
    }

    public function generateClassAnnualResultQrCode($class, $year, $currentUrl = null, $batch = null): string
    {
        $data = [
            'class' => $class->display_name,
            'batch' => $batch ? $batch->name : 'All Batches',
            'academic_year' => $year . '/' . ($year + 1),
            'result_type' => 'Class Annual Result',
            'school' => config('app.name'),
            'result_url' => $currentUrl
        ];

        return QrCode::size(120)
            ->format('svg')
            ->generate(json_encode($data));
    }

    public function generateAnnualMasterListQrCode($class, $year, $currentUrl = null, $batch = null): string
    {
        $data = [
            'class' => $class->display_name,
            'batch' => $batch ? $batch->name : 'All Batches',
            'academic_year' => $year . '/' . ($year + 1),
            'result_type' => 'Annual Master List',
            'school' => config('app.name'),
            'result_url' => $currentUrl
        ];

        return QrCode::size(120)
            ->format('svg')
            ->generate(json_encode($data));
    }

    public function generateMasterListQrCode($session, $class, $currentUrl = null, $batch = null): string
    {
        $data = [
            'class' => $class->display_name,
            'batch' => $batch ? $batch->name : 'All Batches',
            'session' => $session->name . ' ' . $session->start_year . '/' . $session->end_year,
            'result_type' => 'Termly Master List',
            'school' => config('app.name'),
            'result_url' => $currentUrl
        ];

        return QrCode::size(120)
            ->format('svg')
            ->generate(json_encode($data));
    }
}