<?php

namespace App\Services;

use App\Models\SchoolClass;
use Illuminate\Pagination\LengthAwarePaginator;

class SchoolClassService
{
    public function getAllPaginated(int $perPage = 10): LengthAwarePaginator
    {
        return SchoolClass::orderBy('order')->paginate($perPage);
    }

    public function create(array $data): SchoolClass
    {
        if (!isset($data['order']) || $data['order'] === null) {
            $data['order'] = (SchoolClass::max('order') ?? 0) + 1;
        }
        return SchoolClass::create($data);
    }

    public function update(SchoolClass $schoolClass, array $data): bool
    {
        return $schoolClass->update($data);
    }

    public function delete(SchoolClass $schoolClass): bool
    {
        return $schoolClass->delete();
    }

    public function toggleStatus(SchoolClass $schoolClass): bool
    {
        return $schoolClass->update(['is_active' => !$schoolClass->is_active]);
    }
}
