<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->id(); // matches dataset integer id
            $table->string('name', 100);
            $table->char('iso2', 2)->nullable()->index();
            $table->char('iso3', 3)->nullable();
            $table->string('numeric_code', 3)->nullable();
            $table->string('phonecode', 64)->nullable();
            $table->string('capital', 191)->nullable();
//            $table->string('currency', 16)->nullable();
//            $table->string('currency_name', 64)->nullable();
//            $table->string('currency_symbol', 16)->nullable();
//            $table->string('tld', 16)->nullable();
//            $table->string('native', 191)->nullable();
//            $table->string('region', 191)->nullable();
//            $table->string('subregion', 191)->nullable();
//            $table->json('timezones')->nullable();
//            $table->json('translations')->nullable();
//            $table->string('latitude', 32)->nullable();
//            $table->string('longitude', 32)->nullable();
//            $table->string('emoji', 16)->nullable();
//            $table->string('emojiU', 64)->nullable();
            $table->timestamps();
        });

        Schema::create('states', function (Blueprint $table) {
            $table->id(); // matches dataset integer id
            $table->foreignId('country_id')->constrained('countries')->cascadeOnDelete();
            $table->string('name', 191);
//            $table->string('state_code', 64)->nullable()->index();
//            $table->string('type', 64)->nullable(); // province/state/region etc
//            $table->string('latitude', 32)->nullable();
//            $table->string('longitude', 32)->nullable();
//            $table->timestamps();

            $table->index(['country_id', 'name']);
        });

        Schema::create('cities', function (Blueprint $table) {
            $table->id(); // matches dataset integer id
            $table->foreignId('state_id')->nullable()->constrained('states')->nullOnDelete();
            $table->string('name', 191)->index();
//            $table->foreignId('country_id')->constrained('countries')->cascadeOnDelete();
//            $table->string('latitude', 32)->nullable();
//            $table->string('longitude', 32)->nullable();
//            $table->timestamps();

//            $table->index(['country_id', 'state_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cities');
        Schema::dropIfExists('states');
        Schema::dropIfExists('countries');
    }
};
