<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('school_sessions', function (Blueprint $table) {
            $table->integer('grade_a_min')->default(80)->after('exam_pass_mark');
            $table->integer('grade_b_min')->default(70)->after('grade_a_min');
            $table->integer('grade_c_min')->default(60)->after('grade_b_min');
            $table->integer('grade_d_min')->default(50)->after('grade_c_min');
            $table->integer('grade_e_min')->default(40)->after('grade_d_min');
            $table->integer('grade_f_min')->default(0)->after('grade_e_min');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('school_sessions', function (Blueprint $table) {
            $table->dropColumn([
                'grade_a_min',
                'grade_b_min', 
                'grade_c_min',
                'grade_d_min',
                'grade_e_min',
                'grade_f_min'
            ]);
        });
    }
};
