<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('school_sessions', function (Blueprint $table) {
            $table->string('slug')->nullable()->after('name');
        });
        
        // Generate slugs for existing records
        $sessions = \App\Models\SchoolSession::all();
        foreach ($sessions as $session) {
            $session->slug = \Illuminate\Support\Str::slug($session->name);
            $session->save();
        }
        
        // Make slug unique after populating
        Schema::table('school_sessions', function (Blueprint $table) {
            $table->string('slug')->unique()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('school_sessions', function (Blueprint $table) {
            $table->dropColumn('slug');
        });
    }
};
