<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('announcements', function (Blueprint $table) {
            $table->id();
            $table->string('announcement_id', 10)->unique();
            $table->string('title');
            $table->longText('message');
            $table->enum('type', ['popup', 'fixed'])->default('popup');
            $table->enum('alert_type', ['success', 'warning', 'info', 'error'])->default('info');
            $table->enum('target_type', ['student', 'class', 'batch', 'staff', 'all', 'all_students', 'all_staff']);
            $table->unsignedBigInteger('target_id')->nullable();
            $table->datetime('display_from')->nullable();
            $table->datetime('display_until')->nullable();
            $table->boolean('active')->default(true);
            $table->foreignId('created_by')->constrained('users');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('announcements');
    }
};
