<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('result_approvals', function (Blueprint $table) {
            $table->json('class_snapshot')->nullable()->after('subjects_snapshot')->comment('Snapshot of class details at approval time');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('result_approvals', function (Blueprint $table) {
            $table->dropColumn('class_snapshot');
        });
    }
};
