<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Announcement;
use App\Models\User;

class AnnouncementSeeder extends Seeder
{
    public function run(): void
    {
        $admin = User::whereHas('roles', function($q) {
            $q->where('name', 'admin');
        })->first();

        if ($admin) {
            // Create a welcome popup announcement
            Announcement::create([
                'title' => 'Welcome to School Portal!',
                'message' => 'Welcome to our new school management system. Explore all the features available to you.',
                'type' => 'popup',
                'alert_type' => 'success',
                'target_type' => 'all',
                'active' => true,
                'created_by' => $admin->id,
            ]);

            // Create a fixed announcement
            Announcement::create([
                'title' => 'System Maintenance Notice',
                'message' => 'Please note that the system will undergo maintenance this weekend. Some features may be temporarily unavailable.',
                'type' => 'fixed',
                'alert_type' => 'warning',
                'target_type' => 'all',
                'display_from' => now(),
                'display_until' => now()->addDays(7),
                'active' => true,
                'created_by' => $admin->id,
            ]);
        }
    }
}