<?php

namespace Database\Seeders;

use App\Models\City;
use App\Models\Country;
use App\Models\State;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LocationSeeder extends Seeder
{
    public function run(): void
    {
        $this->seedCountries();
        $this->seedStates();
        $this->seedCities();
    }

    private function seedCountries(): void
    {
        $file = fopen(database_path('seeders/data/countries.csv'), 'r');
        $headers = fgetcsv($file);
        
        $data = [];
        while (($row = fgetcsv($file)) !== false) {
            $record = array_combine($headers, $row);
            $data[] = [
                'id' => $record['id'],
                'name' => $record['name'],
                'iso3' => $record['iso3'],
                'iso2' => $record['iso2'],
                'numeric_code' => $record['numeric_code'],
                'phonecode' => $record['phonecode'],
                'capital' => $record['capital'],
            ];

            if (count($data) >= 100) {
                DB::table('countries')->insert($data);
                $data = [];
            }
        }
        
        if (!empty($data)) {
            DB::table('countries')->insert($data);
        }
        
        fclose($file);
    }

    private function seedStates(): void
    {
        $file = fopen(database_path('seeders/data/states.csv'), 'r');
        $headers = fgetcsv($file);
        
        $data = [];
        while (($row = fgetcsv($file)) !== false) {
            $record = array_combine($headers, $row);
            $data[] = [
                'id' => $record['id'],
                'name' => $record['name'],
                'country_id' => $record['country_id'],
            ];

            if (count($data) >= 100) {
                DB::table('states')->insert($data);
                $data = [];
            }
        }
        
        if (!empty($data)) {
            DB::table('states')->insert($data);
        }
        
        fclose($file);
    }

    private function seedCities(): void
    {
        $file = fopen(database_path('seeders/data/cities.csv'), 'r');
        $headers = fgetcsv($file);
        
        $data = [];
        while (($row = fgetcsv($file)) !== false) {
            $record = array_combine($headers, $row);
            $data[] = [
                'id' => $record['id'],
                'name' => $record['name'],
                'state_id' => $record['state_id'],
            ];

            if (count($data) >= 100) {
                DB::table('cities')->insert($data);
                $data = [];
            }
        }
        
        if (!empty($data)) {
            DB::table('cities')->insert($data);
        }
        
        fclose($file);
    }
}
