<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\User;

class PopulateResultsUserIdSeeder extends Seeder
{
    public function run()
    {
        $results = DB::table('results')->whereNull('user_id')->get();
        $count = 0;
        $notFound = 0;

        foreach ($results as $result) {
            $user = User::where('student_id', $result->student_id)->first();
            
            if ($user) {
                DB::table('results')
                    ->where('id', $result->id)
                    ->update(['user_id' => $user->id]);
                $count++;
            } else {
                $notFound++;
                $this->command->warn("User not found for student_id: {$result->student_id}");
            }

            if (($count + $notFound) % 500 === 0) {
                $this->command->info("Processed " . ($count + $notFound) . " records (Updated: {$count}, Not Found: {$notFound})...");
            }
        }

        $this->command->info("Complete! Updated: {$count}, Not Found: {$notFound}");
    }
}
