<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            [
                'name' => 'admin',
                'display_name' => 'Administrator',
                'description' => 'Has unlimited access to the system',
                'permissions' => ['*']
            ],
            [
                'name' => 'bursar',
                'display_name' => 'Bursar',
                'description' => 'Can manage payment records and financial records',
                'permissions' => ['manage_payments', 'view_financial_records', 'manage_fees']
            ],
            [
                'name' => 'head_teacher',
                'display_name' => 'Head Teacher',
                'description' => 'Can manage teachers, students, classes, and all academic activities',
                'permissions' => ['manage_teachers', 'manage_students', 'manage_classes', 'manage_results', 'manage_attendance', 'view_payments', 'promote_students']
            ],
            [
                'name' => 'teacher',
                'display_name' => 'Teacher',
                'description' => 'Can manage own students results and attendance',
                'permissions' => ['manage_own_results', 'manage_own_attendance', 'view_own_students']
            ],
            [
                'name' => 'driver',
                'display_name' => 'Driver',
                'description' => 'School driver',
                'permissions' => []
            ],
            [
                'name' => 'security',
                'display_name' => 'Security',
                'description' => 'School security',
                'permissions' => []
            ],
            [
                'name' => 'cleaner',
                'display_name' => 'Cleaner',
                'description' => 'School cleaner',
                'permissions' => []
            ]
        ];

        foreach ($roles as $roleData) {
            Role::updateOrCreate(
                ['name' => $roleData['name']],
                $roleData
            );
        }
    }
}
