<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class StudentPasswordSeeder extends Seeder
{
    public function run(): void
    {
        User::whereNotNull('student_id')
            ->chunk(100, function ($users) {
                foreach ($users as $user) {
                    $lastFourDigits = substr($user->student_id, -4);
                    $user->update(['password' => Hash::make($lastFourDigits)]);
                }
            });
    }
}
