<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::firstOrCreate(
            ['email' => 'anthonyaliduh@gmail.com'],
            [
                'firstname' => 'Anthony',
                'surname' => 'Aliduh',
                'phone' => '08105466018',
                'password' => Hash::make('password'),
            ]
        );

        $role = Role::where('name', 'admin')->first();
        if ($role && !$user->roles()->where('role_id', $role->id)->exists()) {
            $user->roles()->attach($role);
        }
    }
}
