// Sidebar Toggle Functionality
document.addEventListener('DOMContentLoaded', function() {
    const sidebarToggle = document.getElementById('sidebarToggle');
    const sidebar = document.getElementById('sidebar');
    const sidebarOverlay = document.getElementById('sidebarOverlay');

    if (sidebarToggle && sidebar && sidebarOverlay) {
        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.toggle('show');
            sidebarOverlay.classList.toggle('show');
            sidebarToggle.classList.toggle('sidebar-open');
        });

        sidebarOverlay.addEventListener('click', function() {
            sidebar.classList.remove('show');
            sidebarOverlay.classList.remove('show');
            sidebarToggle.classList.remove('sidebar-open');
        });
    }

    // Account type buttons for login modal
    const accountTypeButtons = document.querySelectorAll('.account-type-btn[data-type], .option-card[data-type]');
    const loginModal = document.getElementById('loginModal');
    
    if (accountTypeButtons.length > 0 && loginModal) {
        accountTypeButtons.forEach(button => {
            button.addEventListener('click', function() {
                const accountType = this.getAttribute('data-type');
                const modal = new bootstrap.Modal(loginModal);
                modal.show();
            });
        });
    }
});

// SweetAlert Notification Functions (only if SweetAlert is loaded)
if (typeof Swal !== 'undefined') {
    window.confirmAction = function(title = 'Are you sure?', text = 'This action cannot be undone!', confirmText = 'Yes, proceed!', cancelText = 'Cancel') {
        return Swal.fire({
            title: title,
            html: text,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d02f34',
            cancelButtonColor: '#6c757d',
            confirmButtonText: confirmText,
            cancelButtonText: cancelText
        });
    };

    window.showToast = function(type = 'success', message = '', title = '', icon = null) {
        const styleMap = {
            success: { bg: '#28a745', text: '#ffffff' },
            error: { bg: '#dc3545', text: '#ffffff' },
            warning: { bg: '#ffc107', text: '#212529' },
            info: { bg: '#17a2b8', text: '#ffffff' }
        };

        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            customClass: {
                title: 'toast-title',
                htmlContainer: 'toast-text'
            },
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
                // Force white text color
                const style = styleMap[type] || styleMap.success;
                const titleElement = toast.querySelector('.swal2-title');
                const textElement = toast.querySelector('.swal2-html-container');
                if (titleElement) titleElement.style.setProperty('color', style.text, 'important');
                if (textElement) textElement.style.setProperty('color', style.text, 'important');
            }
        });

        Toast.fire({
            icon: icon || type,
            title: title || message,
            text: title ? message : '',
            background: styleMap[type]?.bg || styleMap.success.bg,
            color: styleMap[type]?.text || styleMap.success.text
        });
    };

    window.confirmLogout = function(event, logoutUrl) {
        event.preventDefault();
        Swal.fire({
            title: 'Logout Confirmation',
            text: 'Are you sure you want to logout?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#d02f34',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, Logout',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = logoutUrl;
            }
        });
    };
}

// Mobile accordion chevron animation
document.addEventListener('DOMContentLoaded', function() {
    initializeChevrons();
});

function initializeChevrons() {
    const accordionToggles = document.querySelectorAll('[data-bs-toggle="collapse"]');
    
    accordionToggles.forEach(toggle => {
        const chevron = toggle.querySelector('.fa-chevron-down');
        if (chevron) {
            // Set initial state - all accordions start collapsed
            toggle.classList.add('collapsed');
            toggle.setAttribute('aria-expanded', 'false');
            chevron.style.transform = 'rotate(0deg)';
            
            // Remove existing listeners to prevent duplicates
            toggle.removeEventListener('click', handleChevronClick);
            toggle.addEventListener('click', handleChevronClick);
        }
    });
}

function handleChevronClick(event) {
    const toggle = event.currentTarget;
    const chevron = toggle.querySelector('.fa-chevron-down');
    
    if (chevron) {
        setTimeout(() => {
            const isExpanded = toggle.getAttribute('aria-expanded') === 'true';
            chevron.style.transform = isExpanded ? 'rotate(180deg)' : 'rotate(0deg)';
        }, 50);
    }
}

// Livewire Event Listeners
document.addEventListener('livewire:init', () => {
    if (typeof Swal !== 'undefined') {
        Livewire.on('confirm-action', (event) => {
            const data = event[0];
            confirmAction(data.title, data.text, data.confirmText, data.cancelText)
                .then((result) => {
                    if (result.isConfirmed) {
                        Livewire.dispatch('action-confirmed');
                    }
                });
        });

        Livewire.on('show-toast', (event) => {
            const data = event[0];
            showToast(data.type, data.message, data.title, data.icon);
        });
    }
    
    // Re-initialize chevron animations after Livewire updates
    Livewire.hook('morph.updated', () => {
        initializeChevrons();
    });
});