@if ($paginator->hasPages())
    <div class="my-2">
        <div class="text-center text-muted mb-2" style="font-size: 0.875rem;">
            Page {{ $paginator->currentPage() }} of {{ $paginator->lastPage() }}
        </div>
        <nav>
            <ul class="pagination justify-content-center">
                {{-- Previous Page Link --}}
                @if ($paginator->onFirstPage())
                    <li class="page-item disabled"><span class="page-link"><span
                                class="d-none d-md-inline">Previous</span><span
                                class="d-inline d-md-none">&lt;</span></span></li>
                @else
                    <li class="page-item">
                        <button class="page-link" wire:click="previousPage" rel="prev"><span class="d-none d-md-inline">Previous</span><span
                                class="d-inline d-md-none">&lt;</span></button>
                    </li>
                @endif

                {{-- Pagination Elements --}}
                @php
                    $currentPage = $paginator->currentPage();
                    $lastPage = $paginator->lastPage();
                @endphp

                @foreach ($elements as $element)
                    {{-- "Three Dots" Separator --}}
                    @if (is_string($element))
                        <li class="page-item disabled page-ellipsis"><span class="page-link">{{ $element }}</span></li>
                    @endif

                    {{-- Array Of Links --}}
                    @if (is_array($element))
                        @foreach ($element as $page => $url)
                            @php
                                $distance = abs($page - $currentPage);
                                $isFirstOrLast = $page == 1 || $page == $lastPage;
                                $cssClass = '';
                                if (!$isFirstOrLast && $distance > 1) {
                                    $cssClass = 'page-far';
                                }
                            @endphp
                            @if ($page == $currentPage)
                                <li class="page-item active"><span class="page-link">{{ $page }}</span></li>
                            @else
                                <li class="page-item {{ $cssClass }}">
                                    <button class="page-link" wire:click="gotoPage({{ $page }})">
                                        @if ($page == 1)
                                            <span class="d-none d-md-inline">{{ $page }}</span><span
                                                class="d-inline d-md-none">&laquo;</span>
                                        @elseif ($page == $lastPage)
                                            <span class="d-none d-md-inline">{{ $page }}</span><span
                                                class="d-inline d-md-none">&raquo;</span>
                                        @else
                                            {{ $page }}
                                        @endif
                                    </button>
                                </li>
                            @endif
                        @endforeach
                    @endif
                @endforeach

                {{-- Next Page Link --}}
                @if ($paginator->hasMorePages())
                    <li class="page-item">
                        <button class="page-link" wire:click="nextPage" rel="next"><span
                                class="d-none d-md-inline">Next</span><span class="d-inline d-md-none">&gt;</span>
                        </button>
                    </li>
                @else
                    <li class="page-item disabled"><span class="page-link"><span
                                class="d-none d-md-inline">Next</span><span
                                class="d-inline d-md-none">&gt;</span></span></li>
                @endif
            </ul>
        </nav>
    </div>
@endif

<style>
    .pagination .page-link {
        color: var(--primary-color);
        border-color: #dee2e6;
        text-decoration: none;
    }

    .pagination .page-link:hover {
        color: var(--primary-color);
        background-color: #f8f9fa;
        border-color: var(--primary-color);
        text-decoration: none;
    }

    .pagination .page-item.active .page-link {
        background-color: var(--primary-color);
        border-color: var(--primary-color);
        color: white;
        text-decoration: none;
    }

    .pagination .page-item.disabled .page-link {
        color: #6c757d;
        background-color: #fff;
        border-color: #dee2e6;
        text-decoration: none;
    }

    @media (max-width: 767px) {
        .pagination .page-item.page-far,
        .pagination .page-item.page-ellipsis {
            display: none;
        }
    }
</style>
