<div>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title mb-0">Create Payment</h4>
        </div>
        <div class="card-body">
            <form wire:submit.prevent="save">
                <!-- Student Search -->
                <div class="mb-3">
                    <label for="student_search" class="form-label">Student <span class="text-danger">*</span></label>
                    <div class="position-relative">
                        <input type="text" class="form-control" id="student_search" 
                               wire:model.live="student_search" 
                               placeholder="Search by name or student ID..."
                               autocomplete="off">
                        
                        @if($show_search_results && count($search_results) > 0)
                            <div class="position-absolute w-100 bg-white border rounded shadow-sm mt-1" style="z-index: 1000; max-height: 200px; overflow-y: auto;">
                                @foreach($search_results as $student)
                                    <div class="p-2 border-bottom cursor-pointer hover-bg-light" 
                                         wire:click="selectStudent({{ $student->id }})"
                                         style="cursor: pointer;">
                                        <div class="d-flex justify-content-between">
                                            <div>
                                                <strong>{{ $student->name }}</strong>
                                                <small class="text-muted d-block">ID: {{ $student->student_id }}</small>
                                            </div>
                                            @if($student->batch)
                                                <small class="text-muted">
                                                    {{ $student->batch->schoolClass->name ?? '' }} - {{ $student->batch->name }}
                                                </small>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                    @error('selected_student_id') <div class="text-danger small">{{ $message }}</div> @enderror
                </div>

                @if($selected_student_id)
                    <!-- Payment Request (Optional) -->
                    <div class="mb-3">
                        <label for="payment_request_id" class="form-label">Payment Request (Optional)</label>
                        <select class="form-select" id="payment_request_id" wire:model.live="payment_request_id">
                            <option value="">Select a payment request (optional)</option>
                            @foreach($payment_requests as $request)
                                <option value="{{ $request->id }}">
                                    {{ $request->title }} - {{ \App\Helpers\CurrencyHelper::getSymbol($request->currency) }}{{ number_format($request->amount, 0) }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Amount -->
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="amount" class="form-label">Amount <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="amount" 
                                       wire:model="amount" step="0.01" min="0.01" placeholder="0.00"
                                       @if($payment_request_id) readonly @endif>
                                @error('amount') <div class="text-danger small">{{ $message }}</div> @enderror
                                @if($payment_request_id)
                                    <small class="text-muted">Amount is set by the selected payment request</small>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="currency" class="form-label">Currency</label>
                                <select class="form-select" id="currency" wire:model="currency" @if($payment_request_id) disabled @endif>
                                    <option value="NGN">NGN</option>
                                    <option value="USD">USD</option>
                                    <option value="EUR">EUR</option>
                                </select>
                                @if($payment_request_id)
                                    <small class="text-muted">Currency is set by the selected payment request</small>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="mb-3">
                        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                        <select class="form-select" id="status" wire:model="status">
                            <option value="successful">Successful</option>
                            <option value="pending">Pending</option>
                            <option value="failed">Failed</option>
                        </select>
                        @error('status') <div class="text-danger small">{{ $message }}</div> @enderror
                    </div>

                    <!-- Notes -->
                    <div class="mb-3">
                        <label for="notes" class="form-label">Notes <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="notes" wire:model="notes" rows="3" 
                                  placeholder="Add notes about this payment..."></textarea>
                        @error('notes') <div class="text-danger small">{{ $message }}</div> @enderror
                    </div>

                    <!-- Actions -->
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('payments.history') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>Back
                        </a>
                        <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                            <i class="fas fa-save me-2"></i>
                            <span wire:loading.remove wire:target="save">Create Payment</span>
                            <span wire:loading wire:target="save">Creating...</span>
                        </button>
                    </div>
                @endif
            </form>
        </div>
    </div>
    
    <style>
    .hover-bg-light:hover {
        background-color: #f8f9fa !important;
    }
    </style>
</div>