<form wire:submit.prevent="create">
    <div class="mb-3">
        <label for="name" class="form-label">Subject Name <span class="text-danger">*</span></label>
        <input type="text" wire:model="name" class="form-control @error('name') is-invalid @enderror" id="name" placeholder="Enter subject name">
        @error('name')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    
    <div class="d-flex justify-content-end gap-2">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>Create Subject
        </button>
    </div>
</form>

<script>
document.addEventListener('livewire:init', function () {
    Livewire.on('close-modal', function () {
        const modal = bootstrap.Modal.getInstance(document.getElementById('createSubjectModal'));
        if (modal) {
            modal.hide();
        }
    });
    
    Livewire.on('subjectCreated', function () {
        Livewire.dispatch('$refresh');
    });
});
</script>