<div>
    @if($deletedSubjects->count() > 0)
        <div class="d-none d-md-block">
            <div class="table-responsive">
                <table class="table table-striped table-sm">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Deleted At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($deletedSubjects as $subject)
                            <tr>
                                <td>{{ $subject->name }}</td>
                                <td>{{ $subject->deleted_at->format('M d, Y H:i') }}</td>
                                <td>
                                    <button wire:click="confirmRestore({{ $subject->id }})"
                                            class="btn btn-success btn-sm">
                                        <i class="fas fa-undo"></i> Restore
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <div class="d-md-none">
            @foreach($deletedSubjects as $subject)
                <div class="accordion mb-2" id="deleted-subject-{{ $subject->id }}">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                    data-bs-target="#collapse-deleted-{{ $subject->id }}">
                                {{ $subject->name }} <small class="text-muted ms-2">(Deleted)</small>
                            </button>
                        </h2>
                        <div id="collapse-deleted-{{ $subject->id }}" class="accordion-collapse collapse">
                            <div class="accordion-body">
                                <p><strong>Deleted At:</strong> {{ $subject->deleted_at->format('M d, Y H:i') }}</p>
                                <button wire:click="confirmRestore({{ $subject->id }})"
                                        class="btn btn-success btn-sm">
                                    <i class="fas fa-undo"></i> Restore
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <p class="text-muted text-center">No deleted subjects found.</p>
    @endif
</div>
