<div class="card border-0">
    <div class="card-header">
        <h4>Login to your account</h4>
    </div>
    <div class="card-body">
        <form wire:submit.prevent="doLogin">
            <div class="mb-3">
                <label for="login" class="form-label">Username, Email, Phone, or Student ID</label>
                <input type="text" wire:model="login" id="login"
                    class="form-control @error('login') is-invalid @enderror" required autocomplete="username" autofocus
                    placeholder="Enter username, email, phone number, or student ID">
                @error('login')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
            </div>

            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <input type="password" wire:model="password" id="password"
                    class="form-control @error('password') is-invalid @enderror" required
                    autocomplete="current-password">
                @error('password')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
            </div>

            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" wire:model="remember" id="rememberMe">
                    <label class="form-check-label" for="rememberMe">
                        Remember me
                    </label>
                </div>
                @if (Route::has('password.request'))
                    <a class="small" href="{{ route('password.request') }}">Forgot password?</a>
                @endif
            </div>

            <div class="d-grid">
                <button type="submit" class="btn btn-login" wire:loading.attr="disabled">
                    <span wire:loading.remove>Sign in</span>
                    <span wire:loading>
                        <span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                        Signing in...
                    </span>
                </button>
            </div>
        </form>
    </div>
</div>
