<div>
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="mb-3">
                <label for="target_type" class="form-label">Target Type</label>
                <select class="form-select" id="target_type" wire:model.live="target_type">
                    <option value="student">Student</option>
                    <option value="class">Class</option>
                    <option value="batch">Batch</option>
                    <option value="all_students">All Students</option>
                </select>
            </div>
        </div>
        <div class="col-md-6">
            @if($target_type !== 'all_students')
                <div class="mb-3">
                    <label for="target_id" class="form-label">Select {{ ucfirst($target_type) }}</label>
                    <select class="form-select" id="target_id" wire:model.live="target_id">
                        <option value="">Choose {{ ucfirst($target_type) }}</option>
                        @if($target_type === 'student')
                            @foreach($students as $student)
                                <option value="{{ $student->id }}">{{ $student->name }}</option>
                            @endforeach
                        @elseif($target_type === 'class')
                            @foreach($classes as $class)
                                <option value="{{ $class->id }}">{{ $class->alias ?: $class->name }}</option>
                            @endforeach
                        @elseif($target_type === 'batch')
                            @foreach($batches as $batch)
                                <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                            @endforeach
                        @endif
                    </select>
                </div>
            @else
                <div class="mb-3">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Showing payment requests for all students in the school.
                    </div>
                </div>
            @endif
        </div>
    </div>

    @if($targetName && count($paymentRequests) > 0)
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Payment Requests for {{ $targetName }}</h5>
            </div>
            <div class="card-body">
                <!-- Desktop Table -->
                <div class="table-responsive d-none d-lg-block">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Title</th>
                                <th>Description</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Balance</th>
                                <th>Created</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($paymentRequests as $payment)
                                <tr>
                                    <td>{{ $payment->title }}</td>
                                    <td>{{ Str::limit($payment->description, 50) }}</td>
                                    <td>{{ $payment->currency }} {{ number_format($payment->amount, 2) }}</td>
                                    <td>
                                        <span class="badge bg-{{ $payment->status === 'paid' ? 'success' : ($payment->status === 'cancelled' ? 'danger' : ($payment->status === 'expired' ? 'dark' : ($payment->status === 'partial_payment' ? 'warning' : 'secondary'))) }}">
                                            {{ ucfirst(str_replace('_', ' ', $payment->status)) }}
                                        </span>
                                    </td>
                                    <td>{{ $payment->currency }} {{ number_format($payment->balance, 2) }}</td>
                                    <td>{{ $payment->created_at->format('M d, Y') }}</td>
                                </tr>
                                @if($payment->meta && isset($payment->meta['payment_history']))
                                    <tr>
                                        <td colspan="6">
                                            <div class="ms-4">
                                                <strong>Payment History:</strong>
                                                <ul class="list-unstyled mt-2">
                                                    @foreach($payment->meta['payment_history'] as $history)
                                                        <li class="text-muted small">
                                                            {{ $payment->currency }} {{ number_format($history['amount'], 2) }} 
                                                            on {{ \Carbon\Carbon::parse($history['date'])->format('M d, Y') }}
                                                            by {{ $history['recorded_by'] }}
                                                            @if($history['notes'])
                                                                - {{ $history['notes'] }}
                                                            @endif
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Mobile Accordions -->
                <div class="d-lg-none">
                    @foreach($paymentRequests as $payment)
                        <div class="card mb-2">
                            <div class="card-header" data-bs-toggle="collapse" data-bs-target="#payment{{ $payment->id }}">
                                <div class="d-flex justify-content-between align-items-center">
                                    <strong>{{ $payment->title }}</strong>
                                    <span class="badge bg-{{ $payment->status === 'paid' ? 'success' : ($payment->status === 'cancelled' ? 'danger' : ($payment->status === 'expired' ? 'dark' : ($payment->status === 'partial_payment' ? 'warning' : 'secondary'))) }}">
                                        {{ ucfirst(str_replace('_', ' ', $payment->status)) }}
                                    </span>
                                </div>
                            </div>
                            <div class="collapse" id="payment{{ $payment->id }}">
                                <div class="card-body">
                                    <p><strong>Description:</strong> {{ $payment->description }}</p>
                                    <p><strong>Amount:</strong> {{ $payment->currency }} {{ number_format($payment->amount, 2) }}</p>
                                    <p><strong>Balance:</strong> {{ $payment->currency }} {{ number_format($payment->balance, 2) }}</p>
                                    <p><strong>Created:</strong> {{ $payment->created_at->format('M d, Y') }}</p>
                                    
                                    @if($payment->meta && isset($payment->meta['payment_history']))
                                        <div class="mt-3">
                                            <strong>Payment History:</strong>
                                            <ul class="list-unstyled mt-2">
                                                @foreach($payment->meta['payment_history'] as $history)
                                                    <li class="text-muted small">
                                                        {{ $payment->currency }} {{ number_format($history['amount'], 2) }} 
                                                        on {{ \Carbon\Carbon::parse($history['date'])->format('M d, Y') }}
                                                        by {{ $history['recorded_by'] }}
                                                        @if($history['notes'])
                                                            - {{ $history['notes'] }}
                                                        @endif
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @elseif($targetName && count($paymentRequests) === 0)
        <div class="alert alert-info">
            <i class="fas fa-info-circle me-2"></i>
            No payment requests found for {{ $targetName }}.
        </div>
    @elseif($target_id)
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle me-2"></i>
            Loading payment requests...
        </div>
    @else
        <div class="alert alert-secondary">
            <i class="fas fa-search me-2"></i>
            Please select a {{ $target_type }} to view payment requests.
        </div>
    @endif
</div>