<div>
    <!-- Filters -->
    <div class="row mb-3">
        <div class="col-md-6">
            <input type="text" class="form-control" placeholder="Search payments..." wire:model.live="search">
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="statusFilter">
                <option value="">All Status</option>
                <option value="pending">Pending</option>
                <option value="successful">Successful</option>
                <option value="failed">Failed</option>
                <option value="cancelled">Cancelled</option>
            </select>
        </div>
        <div class="col-md-3">
            <select class="form-select" wire:model.live="perPage">
                <option value="5">5 per page</option>
                <option value="10">10 per page</option>
                <option value="25">25 per page</option>
                <option value="50">50 per page</option>
            </select>
        </div>
    </div>

    @if($payments->count() > 0)
        <!-- Desktop Table -->
        <div class="d-none d-lg-block">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Payment Request</th>
                            <th>Student</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Last Modified</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($payments as $payment)
                            <tr>
                                <td>{{ $payment->paymentRequest?->title ?? 'Direct Payment' }}</td>
                                <td>{{ $payment->user->name }}</td>
                                <td>{{ $payment->currency_symbol }}{{ number_format($payment->amount) }}</td>
                                <td>
                                    <span class="badge bg-{{ $payment->status === 'successful' ? 'success' : ($payment->status === 'failed' ? 'danger' : ($payment->status === 'cancelled' ? 'secondary' : 'warning')) }}">
                                        {{ ucfirst($payment->status) }}
                                    </span>
                                </td>
                                <td>{{ $payment->created_at->format('M d, Y H:i') }}</td>
                                <td>{{ $payment->updated_at->format('M d, Y H:i') }}</td>
                                <td>
                                    <a href="{{ route('payments.view', $payment->payment_id) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-eye me-1"></i>View
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Mobile Accordions -->
        <div class="d-lg-none">
            @foreach($payments as $index => $payment)
                <div class="card mb-2">
                    <div class="card-header p-0">
                        <div class="d-flex">
                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse" data-bs-target="#payment{{ $payment->id }}" style="cursor: pointer;">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="badge bg-light text-dark me-2">{{ $index + 1 }}</span>
                                        <strong>{{ $payment->user->name }}</strong>
                                    </div>
                                    <div>
                                        <i class="fas fa-chevron-down text-muted" style="transform: rotate(0deg); transition: transform 0.3s ease;"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="collapse" id="payment{{ $payment->id }}">
                        <div class="card-body">
                            <div class="mb-3">
                                <div class="d-flex flex-wrap gap-2 mb-2">
                                    <span class="badge bg-primary">{{ $payment->currency_symbol }}{{ number_format($payment->amount) }}</span>
                                    <span class="badge bg-{{ $payment->status === 'successful' ? 'success' : ($payment->status === 'failed' ? 'danger' : ($payment->status === 'cancelled' ? 'secondary' : 'warning')) }}">
                                        {{ ucfirst($payment->status) }}
                                    </span>
                                </div>
                            </div>
                            <p><strong>Payment Request:</strong> {{ $payment->paymentRequest?->title ?? 'Direct Payment' }}</p>
                            <p><strong>Date:</strong> {{ $payment->created_at->format('M d, Y H:i') }}</p>
                            <p><strong>Last Modified:</strong> {{ $payment->updated_at->format('M d, Y H:i') }}</p>
                            <div class="d-flex flex-wrap gap-2">
                                <a href="{{ route('payments.view', $payment->payment_id) }}" class="btn btn-sm btn-primary">
                                    <i class="fas fa-eye me-1"></i>View
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        {{ $payments->links() }}
    @else
        <div class="text-center py-4">
            <i class="fas fa-credit-card fa-3x text-muted mb-3"></i>
            <h5>No Payments Found</h5>
            <p class="text-muted">No payments match your current filters.</p>
        </div>
    @endif
</div>

<script>
    document.addEventListener('shown.bs.collapse', function (e) {
        const chevron = e.target.previousElementSibling.querySelector('.fa-chevron-down');
        if (chevron) chevron.style.transform = 'rotate(180deg)';
    });
    
    document.addEventListener('hidden.bs.collapse', function (e) {
        const chevron = e.target.previousElementSibling.querySelector('.fa-chevron-down');
        if (chevron) chevron.style.transform = 'rotate(0deg)';
    });
</script>