<div>
    <div class="row">
        <div class="col-md-4">
            <div class="mb-3">
                <label for="selectedYear" class="form-label">Select Year</label>
                <select wire:model.live="selectedYear" class="form-select" id="selectedYear">
                    <option value="">Choose Year...</option>
                    @foreach($years as $year)
                        <option value="{{ $year }}">{{ $year }}/{{ $year + 1 }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="mb-3">
                <label for="selectedClass" class="form-label">Select Class</label>
                <select wire:model.live="selectedClass" class="form-select" id="selectedClass" {{ !$selectedYear ? 'disabled' : '' }}>
                    <option value="">Choose Class...</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}">{{ $class->alias ?: $class->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="mb-3">
                <label for="selectedBatch" class="form-label">Select Batch</label>
                <select wire:model.live="selectedBatch" class="form-select" id="selectedBatch" {{ !$selectedClass ? 'disabled' : '' }}>
                    <option value="">Choose Batch...</option>
                    @foreach($batches as $batch)
                        <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>

    @if(count($students) > 0)
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Select Students for Annual Approval</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            @foreach($students as $student)
                                <div class="col-md-4 mb-2">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="{{ $student->id }}" 
                                               wire:model.live="selectedStudents" id="student{{ $student->id }}">
                                        <label class="form-check-label" for="student{{ $student->id }}">
                                            {{ $student->name }}
                                        </label>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        
                        @if(count($selectedStudents) > 0)
                            <div class="mt-3">
                                <button type="button" wire:click="loadStudentResults" class="btn btn-primary">
                                    <i class="fas fa-search me-2"></i>Load Student Results
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @elseif($selectedYear && $selectedClass && $selectedBatch)
        <div class="alert alert-info">
            <i class="fas fa-info-circle me-2"></i>
            <strong>No students meet the search criteria.</strong><br>
            It appears all student results for the selected class, batch, and year have been approved.
        </div>
    @endif

    @if(count($studentResults) > 0)
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Student Annual Results Summary</h5>
                    </div>
                    <div class="card-body">
                        @foreach($studentResults as $studentId => $data)
                            <div class="mb-4">
                                <h6 class="text-primary">{{ $data['student']->name }}</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Subject</th>
                                                @foreach($data['sessions'] as $session)
                                                    <th>{{ $session->name }}</th>
                                                @endforeach
                                                <th>Annual Total</th>
                                                <th>Annual Average</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($data['subjects'] as $subject)
                                                <tr>
                                                    <td>{{ $subject['name'] }}</td>
                                                    @foreach($subject['sessions'] as $sessionResult)
                                                        <td>{{ $sessionResult['total'] ?? 'N/A' }}</td>
                                                    @endforeach
                                                    <td><strong>{{ $subject['annual_total'] }}</strong></td>
                                                    <td><strong>{{ number_format($subject['annual_average'], 1) }}</strong></td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                        <tfoot>
                                            <tr class="table-primary">
                                                <th>Grand Total</th>
                                                @foreach($data['sessions'] as $session)
                                                    <th>{{ $data['sessions_totals'][$session->id] ?? 'N/A' }}</th>
                                                @endforeach
                                                <th><strong>{{ $data['annual_total'] }}</strong></th>
                                                <th><strong>{{ number_format($data['annual_average'], 1) }}</strong></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Approval Details</h5>
                    </div>
                    <div class="card-body">
                        <div>
                            <div class="row">
                                <div class="col-12">
                                    <h6 class="text-primary mb-3">Affective Traits (0-5)</h6>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Punctuality</label>
                                    <input type="number" wire:model="punctuality" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Mental Alertness</label>
                                    <input type="number" wire:model="mental_alertness" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Attentiveness</label>
                                    <input type="number" wire:model="attentiveness" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Respect</label>
                                    <input type="number" wire:model="respect" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Neatness</label>
                                    <input type="number" wire:model="neatness" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Politeness</label>
                                    <input type="number" wire:model="politeness" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Honesty</label>
                                    <input type="number" wire:model="honesty" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Relationship with Peers</label>
                                    <input type="number" wire:model="relationship_with_peers" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Attitude to School</label>
                                    <input type="number" wire:model="attitude_to_school" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Teamwork</label>
                                    <input type="number" wire:model="teamwork" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Completes School Work Promptly</label>
                                    <input type="number" wire:model="completes_school_work_promptly" class="form-control" step="0.1" min="0" max="5">
                                </div>
                            </div>

                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6 class="text-primary mb-3">Psychomotor Skills (0-5)</h6>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Reading</label>
                                    <input type="number" wire:model="reading" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Verbal Fluency/Diction</label>
                                    <input type="number" wire:model="verbal_fluency_diction" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Handwriting</label>
                                    <input type="number" wire:model="handwriting" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Musical Skills</label>
                                    <input type="number" wire:model="musical_skills" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Creative Arts</label>
                                    <input type="number" wire:model="creative_arts" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Physical Education</label>
                                    <input type="number" wire:model="physical_education" class="form-control" step="0.1" min="0" max="5">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">General Reasoning</label>
                                    <input type="number" wire:model="general_reasoning" class="form-control" step="0.1" min="0" max="5">
                                </div>
                            </div>

                            <div class="row mt-4">
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label">Principal/Head Teacher's Remarks</label>
                                        <textarea wire:model="principal_remarks" class="form-control" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-4">
                                <div class="col-12">
                                    <button type="button" wire:click="confirmApproval" class="btn btn-success">
                                        <i class="fas fa-check me-2"></i>Approve Annual Results
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>