<div>
    <style>
        .results-table {
            font-size: 0.875rem;
        }
        
        .results-table .form-control {
            min-width: 60px;
            width: 70px;
            text-align: center;
        }
        
        .student-name-cell {
            min-width: 120px;
            word-wrap: break-word;
            position: sticky;
            left: 0;
            background-color: #f8f9fa;
            z-index: 10;
        }
        
        .results-table tbody .student-name-cell {
            background-color: white;
            z-index: 5;
        }
        
        @media (max-width: 768px) {
            .results-table {
                font-size: 0.75rem;
            }
            
            .results-table .form-control {
                min-width: 45px;
                width: 50px;
                padding: 0.25rem 0.125rem;
                font-size: 0.75rem;
            }
            
            .student-name-cell {
                min-width: 80px;
                font-size: 0.7rem;
            }
            
            .results-table tbody .student-name-cell {
                box-shadow: 2px 0 5px rgba(0,0,0,0.1);
            }
            
            .results-table th {
                padding: 0.25rem 0.125rem;
                font-size: 0.7rem;
            }
            
            .results-table td {
                padding: 0.25rem 0.125rem;
            }
        }
    </style>
    @if(!$canUploadResults)
        <div class="alert alert-warning mb-4">
            <i class="fas fa-exclamation-triangle me-2"></i>
            {{ $uploadDisabledMessage }}
        </div>
    @endif

    @if($excludedStudentsCount > 0)
        <div class="alert alert-info mb-4">
            <i class="fas fa-info-circle me-2"></i>
            {{ $excludedStudentsCount }} student{{ $excludedStudentsCount > 1 ? 's' : '' }} excluded because their
            results have already been approved.
        </div>
    @endif

    <form wire:submit.prevent="saveResults" {{ !$canUploadResults ? 'style=pointer-events:none;opacity:0.6;' : '' }}>
        <div class="row mb-4">
            <div class="col-md-6 col-lg-3">
                <label for="selectedClass" class="form-label">Select Class</label>
                <select wire:model.live="selectedClass" class="form-select" id="selectedClass">
                    <option value="">Choose a class...</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                    @endforeach
                </select>
                @error('selectedClass')
                <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-6 col-lg-3">
                <label for="selectedBatch" class="form-label">Select Batch</label>
                <select wire:model.live="selectedBatch" class="form-select"
                        id="selectedBatch" {{ !$selectedClass ? 'disabled' : '' }}>
                    <option value="">Choose a batch...</option>
                    @foreach($batches as $batch)
                        <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                    @endforeach
                </select>
                @error('selectedBatch')
                <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-6 col-lg-3">
                <label for="selectedSession" class="form-label">Select Session</label>
                <select wire:model.live="selectedSession" class="form-select" id="selectedSession">
                    <option value="">Choose a session...</option>
                    @foreach($sessions as $session)
                        <option value="{{ $session->id }}">{{ $session->name }} ({{ $session->start_year }}
                            /{{ $session->end_year }})
                        </option>
                    @endforeach
                </select>
                @error('selectedSession')
                <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-6 col-lg-3">
                <label class="form-label">&nbsp;</label>
                @if($selectedClass && $selectedBatch && $selectedSession)
                    <button type="button"
                            wire:click="loadResults"
                            class="btn btn-primary w-100"
                            wire:loading.attr="disabled"
                            wire:target="loadResults">
                        <span wire:loading.remove wire:target="loadResults">
                            <i class="fas fa-sync me-2"></i>Load
                        </span>
                        <span wire:loading wire:target="loadResults">
                            <i class="fas fa-spinner fa-spin me-2"></i>Loading...
                        </span>
                    </button>
                @endif
            </div>
        </div>

        @if(!empty($students) && !empty($subjects))
            <div class="mb-3">
                <h5>Class: {{ $classes->find($selectedClass)->display_name ?? 'N/A' }} -
                    Batch: {{ $batches->find($selectedBatch)->name ?? 'N/A' }}</h5>
            </div>
            <div class="table-responsive">
                <table class="table table-bordered table-sm results-table">
                    <thead class="table-light">
                    <tr>
                        <th rowspan="2" class="student-name-cell">
                            Student
                        </th>
                        @foreach($subjects as $subject)
                            <th colspan="4" class="text-center">{{ $subject->display_name }}</th>
                        @endforeach
                    </tr>
                    <tr>
                        @foreach($subjects as $subject)
                            <th class="text-center">CA</th>
                            <th class="text-center" style="width: 40px;">Abs</th>
                            <th class="text-center">Exam</th>
                            <th class="text-center" style="width: 40px;">Abs</th>
                        @endforeach
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($students as $student)
                        <tr>
                            <td class="student-name-cell">
                                <strong>{{ $loop->iteration }}. {{ $student->name }}</strong>
                            </td>
                            @foreach($subjects as $subject)
                                <td>
                                    <input type="number"
                                           wire:model.defer="results.{{ $student->id }}.{{ $subject->id }}.ca_score"
                                           class="form-control form-control-sm result-input"
                                           data-student="{{ $student->id }}"
                                           data-subject="{{ $subject->id }}"
                                           data-field="ca_score"
                                           min="0"
                                           max="{{ $sessions->find($selectedSession)->ca_max_score ?? 100 }}"
                                           step="1"
                                           placeholder="CA"
                                           tabindex="{{ ($loop->parent->iteration - 1) * count($subjects) * 2 + ($loop->iteration - 1) * 2 + 1 }}"
                                        {{ ($results[$student->id][$subject->id]['ca_absent'] ?? false) ? 'disabled' : '' }}>
                                </td>
                                <td class="text-center" style="width: 40px;">
                                    <input type="checkbox"
                                           wire:model.defer="results.{{ $student->id }}.{{ $subject->id }}.ca_absent"
                                           class="form-check-input absent-checkbox"
                                           data-student="{{ $student->id }}"
                                           data-subject="{{ $subject->id }}"
                                           data-field="ca_absent"
                                           data-target="ca_score"
                                           tabindex="-1">
                                </td>
                                <td>
                                    <input type="number"
                                           wire:model.defer="results.{{ $student->id }}.{{ $subject->id }}.exam_score"
                                           class="form-control form-control-sm result-input"
                                           data-student="{{ $student->id }}"
                                           data-subject="{{ $subject->id }}"
                                           data-field="exam_score"
                                           min="0"
                                           max="{{ $sessions->find($selectedSession)->exam_max_score ?? 100 }}"
                                           step="1"
                                           placeholder="Exam"
                                           tabindex="{{ ($loop->parent->iteration - 1) * count($subjects) * 2 + ($loop->iteration - 1) * 2 + 2 }}"
                                        {{ ($results[$student->id][$subject->id]['exam_absent'] ?? false) ? 'disabled' : '' }}>
                                </td>
                                <td class="text-center" style="width: 40px;">
                                    <input type="checkbox"
                                           wire:model.defer="results.{{ $student->id }}.{{ $subject->id }}.exam_absent"
                                           class="form-check-input absent-checkbox"
                                           data-student="{{ $student->id }}"
                                           data-subject="{{ $subject->id }}"
                                           data-field="exam_absent"
                                           data-target="exam_score"
                                           tabindex="-1">
                                </td>
                            @endforeach
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-end mt-3">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="fas fa-save me-2"></i>Save All Results
                </button>
            </div>
        @endif
    </form>
</div>

<script>
    let updateCounter = 0;
    let pendingUpdates = new Set();

    document.addEventListener('input', function (e) {
        if (e.target.type === 'number' && e.target.hasAttribute('max')) {
            const max = parseInt(e.target.getAttribute('max'));
            const value = parseInt(e.target.value);
            if (value > max) {
                e.target.setCustomValidity(`Value must not exceed ${max}`);
                e.target.reportValidity();
            } else {
                e.target.setCustomValidity('');
            }
        }
        
        // Track result input changes
        if (e.target.classList.contains('result-input')) {
            const studentId = e.target.dataset.student;
            const subjectId = e.target.dataset.subject;
            const key = `${studentId}_${subjectId}`;
            
            if (!pendingUpdates.has(key)) {
                pendingUpdates.add(key);
                updateCounter++;
                
                if (updateCounter >= 10) {
                    saveUpdates();
                }
            }
        }
    });
    
    document.addEventListener('change', function (e) {
        // Handle absent checkbox changes
        if (e.target.classList.contains('absent-checkbox')) {
            const studentId = e.target.dataset.student;
            const subjectId = e.target.dataset.subject;
            const targetField = e.target.dataset.target;
            
            // Disable/enable corresponding input
            const targetInput = document.querySelector(
                `input[data-student="${studentId}"][data-subject="${subjectId}"][data-field="${targetField}"]`
            );
            
            if (targetInput) {
                if (e.target.checked) {
                    targetInput.value = 0;
                    targetInput.disabled = true;
                } else {
                    targetInput.disabled = false;
                }
            }
            
            const key = `${studentId}_${subjectId}`;
            if (!pendingUpdates.has(key)) {
                pendingUpdates.add(key);
                updateCounter++;
                
                if (updateCounter >= 10) {
                    saveUpdates();
                }
            }
        }
    });
    
    function saveUpdates() {
        if (updateCounter > 0) {
            @this.call('processPendingUpdates');
            updateCounter = 0;
            pendingUpdates.clear();
        }
    }
    
    // Save any remaining updates before form submission
    document.addEventListener('livewire:init', () => {
        Livewire.hook('commit', ({ component, commit, respond, succeed, fail }) => {
            if (component.name === 'results.by-class-form') {
                saveUpdates();
            }
        });
    });
</script>
