<div>
    @if(!$canUploadResults)
        <div class="alert alert-warning mb-4">
            <i class="fas fa-exclamation-triangle me-2"></i>
            {{ $uploadDisabledMessage }}
        </div>
    @endif
    
    @if($excludedStudentsCount > 0)
        <div class="alert alert-info mb-4">
            <i class="fas fa-info-circle me-2"></i>
            {{ $excludedStudentsCount }} student{{ $excludedStudentsCount > 1 ? 's' : '' }} excluded because their results have already been approved.
        </div>
    @endif
    
    <form wire:submit.prevent="saveResults" {{ !$canUploadResults ? 'style=pointer-events:none;opacity:0.6;' : '' }}>
        <div class="row mb-4">
            <div class="col-md-6 col-lg-2">
                <label for="selectedClass" class="form-label">Select Class</label>
                <select wire:model.live="selectedClass" class="form-select" id="selectedClass">
                    <option value="">Choose a class...</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                    @endforeach
                </select>
                @error('selectedClass') <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-6 col-lg-2">
                <label for="selectedBatch" class="form-label">Select Batch</label>
                <select wire:model.live="selectedBatch" class="form-select" id="selectedBatch" {{ !$selectedClass ? 'disabled' : '' }}>
                    <option value="">Choose a batch...</option>
                    @foreach($batches as $batch)
                        <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                    @endforeach
                </select>
                @error('selectedBatch') <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-6 col-lg-3">
                <label for="selectedSubject" class="form-label">Select Subject</label>
                <select wire:model.live="selectedSubject" class="form-select" id="selectedSubject" {{ !$selectedClass ? 'disabled' : '' }}>
                    <option value="">Choose a subject...</option>
                    @foreach($subjects as $subject)
                        <option value="{{ $subject->id }}">{{ $subject->display_name }}</option>
                    @endforeach
                </select>
                @error('selectedSubject') <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-6 col-lg-2">
                <label for="selectedSession" class="form-label">Select Session</label>
                <select wire:model.live="selectedSession" class="form-select" id="selectedSession">
                    <option value="">Choose a session...</option>
                    @foreach($sessions as $session)
                        <option value="{{ $session->id }}">{{ $session->name }} ({{ $session->start_year }}/{{ $session->end_year }})</option>
                    @endforeach
                </select>
                @error('selectedSession') <div class="text-danger">{{ $message }}</div> @enderror
            </div>
            <div class="col-md-12 col-lg-3 d-flex align-items-center">
                @if($selectedClass && $selectedBatch && $selectedSubject && $selectedSession)
                    <button type="button" 
                            wire:click="loadResults" 
                            class="btn btn-primary btn-lg w-100 d-block d-md-inline-block mt-3 mt-lg-0"
                            wire:loading.attr="disabled"
                            wire:target="loadResults">
                        <span wire:loading.remove wire:target="loadResults">
                            <i class="fas fa-sync me-2"></i>Load
                        </span>
                        <span wire:loading wire:target="loadResults">
                            <i class="fas fa-spinner fa-spin me-2"></i>Loading...
                        </span>
                    </button>
                @endif
            </div>
        </div>

        @if(!empty($students))
            <div class="mb-3">
                <h5>Class: {{ $classes->find($selectedClass)->display_name ?? 'N/A' }} - Batch: {{ $batches->find($selectedBatch)->name ?? 'N/A' }} | Subject: {{ $subjects->find($selectedSubject)->display_name ?? 'N/A' }}</h5>
            </div>
            <!-- Desktop Table View -->
            <div class="table-responsive d-none d-md-block">
                <table class="table table-bordered results-table">
                    <thead class="table-light">
                        <tr>
                            <th>Student</th>
                            <th>CA Score</th>
                            <th>CA Abs</th>
                            <th>Exam Score</th>
                            <th>Exam Abs</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($students as $student)
                            <tr>
                                <td><strong>{{ $loop->iteration }}. {{ $student->name }}</strong></td>
                                <td style="min-width: 120px;">
                                    <input type="number" 
                                           wire:model.defer="results.{{ $student->id }}.ca_score" 
                                           class="form-control result-input" 
                                           data-student="{{ $student->id }}"
                                           data-field="ca_score"
                                           style="width: 110px;"
                                           min="0" 
                                           max="{{ $sessions->find($selectedSession)->ca_max_score ?? 100 }}" 
                                           step="1"
                                           tabindex="{{ $loop->iteration * 2 - 1 }}"
                                           {{ ($results[$student->id]['ca_absent'] ?? false) ? 'disabled' : '' }}>
                                    @error("results.{$student->id}.ca_score") <div class="text-danger small">{{ $message }}</div> @enderror
                                </td>
                                <td>
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               wire:model.defer="results.{{ $student->id }}.ca_absent" 
                                               class="form-check-input absent-checkbox" 
                                               data-student="{{ $student->id }}"
                                               data-field="ca_absent"
                                               data-target="ca_score"
                                               id="ca_absent_{{ $student->id }}"
                                               tabindex="-1">
                                        <label class="form-check-label" for="ca_absent_{{ $student->id }}">Abs</label>
                                    </div>
                                </td>
                                <td style="min-width: 120px;">
                                    <input type="number" 
                                           wire:model.defer="results.{{ $student->id }}.exam_score" 
                                           class="form-control result-input" 
                                           data-student="{{ $student->id }}"
                                           data-field="exam_score"
                                           style="width: 110px;"
                                           min="0" 
                                           max="{{ $sessions->find($selectedSession)->exam_max_score ?? 100 }}" 
                                           step="1"
                                           tabindex="{{ $loop->iteration * 2 }}"
                                           {{ ($results[$student->id]['exam_absent'] ?? false) ? 'disabled' : '' }}>
                                    @error("results.{$student->id}.exam_score") <div class="text-danger small">{{ $message }}</div> @enderror
                                </td>
                                <td>
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               wire:model.defer="results.{{ $student->id }}.exam_absent" 
                                               class="form-check-input absent-checkbox" 
                                               data-student="{{ $student->id }}"
                                               data-field="exam_absent"
                                               data-target="exam_score"
                                               id="exam_absent_{{ $student->id }}"
                                               tabindex="-1">
                                        <label class="form-check-label" for="exam_absent_{{ $student->id }}">Abs</label>
                                    </div>
                                </td>
                                <td>
                                    <strong class="total-display" data-student="{{ $student->id }}">
                                        @if(isset($results[$student->id]))
                                            {{ (floatval($results[$student->id]['ca_score'] ?? 0)) + (floatval($results[$student->id]['exam_score'] ?? 0)) }}
                                        @else
                                            0
                                        @endif
                                    </strong>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Mobile Accordion View -->
            <div class="d-md-none" wire:ignore.self>
                @foreach($students as $student)
                    <div class="card mb-3">
                        <div class="card-header" data-bs-toggle="collapse" data-bs-target="#student-{{ $student->id }}" style="cursor: pointer;">
                            <div class="d-flex justify-content-between align-items-center">
                                <strong>{{ $student->name }}</strong>
                                <span class="badge bg-primary total-display-mobile" data-student="{{ $student->id }}">
                                    Total: 
                                    @if(isset($results[$student->id]))
                                        {{ (floatval($results[$student->id]['ca_score'] ?? 0)) + (floatval($results[$student->id]['exam_score'] ?? 0)) }}
                                    @else
                                        0
                                    @endif
                                </span>
                            </div>
                        </div>
                        <div class="collapse" id="student-{{ $student->id }}" wire:ignore.self>
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-6">
                                        <label class="form-label small">CA Score</label>
                                        <input type="number" 
                                               wire:model.defer="results.{{ $student->id }}.ca_score" 
                                               class="form-control result-input" 
                                               data-student="{{ $student->id }}"
                                               data-field="ca_score"
                                               min="0" 
                                               max="{{ $sessions->find($selectedSession)->ca_max_score ?? 100 }}"
                                               step="1"
                                               {{ ($results[$student->id]['ca_absent'] ?? false) ? 'disabled' : '' }}>
                                        @error("results.{$student->id}.ca_score") <div class="text-danger small">{{ $message }}</div> @enderror
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label small">Exam Score</label>
                                        <input type="number" 
                                               wire:model.defer="results.{{ $student->id }}.exam_score" 
                                               class="form-control result-input" 
                                               data-student="{{ $student->id }}"
                                               data-field="exam_score"
                                               min="0" 
                                               max="{{ $sessions->find($selectedSession)->exam_max_score ?? 100 }}"
                                               step="1"
                                               {{ ($results[$student->id]['exam_absent'] ?? false) ? 'disabled' : '' }}>
                                        @error("results.{$student->id}.exam_score") <div class="text-danger small">{{ $message }}</div> @enderror
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-check">
                                            <input type="checkbox" 
                                                   wire:model.defer="results.{{ $student->id }}.ca_absent" 
                                                   class="form-check-input absent-checkbox" 
                                                   data-student="{{ $student->id }}"
                                                   data-field="ca_absent"
                                                   data-target="ca_score"
                                                   id="ca_absent_mobile_{{ $student->id }}">
                                            <label class="form-check-label" for="ca_absent_mobile_{{ $student->id }}">CA Abs</label>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-check">
                                            <input type="checkbox" 
                                                   wire:model.defer="results.{{ $student->id }}.exam_absent" 
                                                   class="form-check-input absent-checkbox" 
                                                   data-student="{{ $student->id }}"
                                                   data-field="exam_absent"
                                                   data-target="exam_score"
                                                   id="exam_absent_mobile_{{ $student->id }}">
                                            <label class="form-check-label" for="exam_absent_mobile_{{ $student->id }}">Exam Abs</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="d-flex justify-content-end mt-3">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="fas fa-save me-2"></i>Save Results
                </button>
            </div>
        @endif
    </form>
</div>

<script>
    let updateCounter = 0;
    let pendingUpdates = new Set();

    document.addEventListener('input', function(e) {
        if (e.target.type === 'number' && e.target.hasAttribute('max')) {
            const max = parseInt(e.target.getAttribute('max'));
            const value = parseInt(e.target.value);
            if (value > max) {
                e.target.setCustomValidity(`Value must not exceed ${max}`);
                e.target.reportValidity();
            } else {
                e.target.setCustomValidity('');
            }
        }
        
        // Track result input changes
        if (e.target.classList.contains('result-input')) {
            const studentId = e.target.dataset.student;
            
            // Update total instantly
            updateTotal(studentId);
            
            if (!pendingUpdates.has(studentId)) {
                pendingUpdates.add(studentId);
                updateCounter++;
                
                if (updateCounter >= 10) {
                    saveUpdates();
                }
            }
        }
    });
    
    document.addEventListener('change', function(e) {
        // Handle absent checkbox changes
        if (e.target.classList.contains('absent-checkbox')) {
            const studentId = e.target.dataset.student;
            const targetField = e.target.dataset.target;
            
            // Disable/enable corresponding input
            const targetInputs = document.querySelectorAll(
                `input[data-student="${studentId}"][data-field="${targetField}"]`
            );
            
            targetInputs.forEach(targetInput => {
                if (e.target.checked) {
                    targetInput.value = 0;
                    targetInput.disabled = true;
                } else {
                    targetInput.disabled = false;
                }
            });
            
            // Update total instantly
            updateTotal(studentId);
            
            if (!pendingUpdates.has(studentId)) {
                pendingUpdates.add(studentId);
                updateCounter++;
                
                if (updateCounter >= 10) {
                    saveUpdates();
                }
            }
        }
    });
    
    function updateTotal(studentId) {
        const caInput = document.querySelector(`input[data-student="${studentId}"][data-field="ca_score"]`);
        const examInput = document.querySelector(`input[data-student="${studentId}"][data-field="exam_score"]`);
        const totalDisplay = document.querySelector(`.total-display[data-student="${studentId}"]`);
        const totalDisplayMobile = document.querySelector(`.total-display-mobile[data-student="${studentId}"]`);
        
        if (caInput && examInput) {
            const caScore = parseFloat(caInput.value) || 0;
            const examScore = parseFloat(examInput.value) || 0;
            const total = caScore + examScore;
            
            if (totalDisplay) {
                totalDisplay.textContent = total;
            }
            if (totalDisplayMobile) {
                totalDisplayMobile.textContent = 'Total: ' + total;
            }
        }
    }
    
    function saveUpdates() {
        if (updateCounter > 0) {
            @this.call('processPendingUpdates');
            updateCounter = 0;
            pendingUpdates.clear();
        }
    }
    
    // Save any remaining updates before form submission
    document.addEventListener('livewire:init', () => {
        Livewire.hook('commit', ({ component, commit, respond, succeed, fail }) => {
            if (component.name === 'results.by-subject-form') {
                saveUpdates();
            }
        });
    });
</script>