<div>
    <!-- Filter Form -->
    <div class="row mb-4">
        <div class="col-md-6 col-lg-2">
            <label for="classId" class="form-label">Class</label>
            <select wire:model.live="classId" class="form-select" id="classId">
                <option value="">Select Class</option>
                @foreach($classes as $class)
                    <option value="{{ $class->id }}">{{ $class->display_name }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-6 col-lg-2">
            <label for="batchId" class="form-label">Batch</label>
            <select wire:model.live="batchId" class="form-select" id="batchId">
                <option value="">Select Batch</option>
                @foreach($batches as $batch)
                    <option value="{{ $batch->id }}">{{ $batch->name }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4 col-lg-3">
            <label for="studentId" class="form-label">Student</label>
            <select wire:model="studentId" class="form-select" id="studentId">
                <option value="">Select Student</option>
                @foreach($students as $student)
                    <option value="{{ $student->id }}">{{ $student->name }} ({{ $student->student_id }})</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4 col-lg-3">
            <label for="year" class="form-label">Academic Year</label>
            <select wire:model="year" class="form-select" id="year">
                <option value="">Select Year</option>
                @foreach($years as $yearOption)
                    <option value="{{ $yearOption }}">{{ $yearOption }}/{{ $yearOption + 1 }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-md-4 col-lg-2 text-end">
            <label class="form-label d-none d-md-block">&nbsp;</label>
            <button wire:click="loadStudentAnnualResult"
                    class="btn btn-primary py-2 w-100 w-md-auto d-md-inline mt-3 mt-md-0">
                <i class="fas fa-search"></i> Load
            </button>
        </div>
    </div>

    @if(!empty($studentData))
        <!-- Student Info Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card bg-light">
                    <div class="card-body">
                        <h5>{{ $selectedStudent->name }}</h5>
                        <p class="mb-1"><strong>Student ID:</strong> {{ $selectedStudent->student_id }}</p>
                        <p class="mb-1"><strong>Class:</strong> {{ $selectedClass->display_name }}</p>
                        <p class="mb-0"><strong>Academic Year:</strong> {{ $selectedYear }}/{{ $selectedYear + 1 }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart and Summary Section -->
        <div class="row mb-4">
            <!-- Chart Column -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0" style="color: var(--primary-color);">Grade Chart</h6>
                    </div>
                    <div class="card-body">
                        <canvas id="gradeChart" width="400" height="300"></canvas>
                    </div>
                </div>
            </div>

            <!-- Summary Column -->
            <div class="col-md-6">
                <!-- Annual Summary Cards -->
                <div class="row mb-3">
                    @php
                        $helpers = app('App\Services\AnnualResultService')->getCalculationHelpers($sessions, $subjects, $studentData);
                        $annualMaxTotal = $helpers['annual_max_total'];
                        $correctedAnnualAverage = $helpers['corrected_annual_average'];
                        $promotionStatus = $helpers['promotion_status'];
                    @endphp
                    <div class="col-6">
                        <div class="card text-center bg-primary">
                            <div class="card-body">
                                <h5 class="card-title text-white">Annual Total</h5>
                                <h3 class="text-white">{{ $studentData['annual_grand_total'] }}
                                    /{{ $annualMaxTotal }}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card text-center bg-success">
                            <div class="card-body">
                                <h5 class="card-title text-white">Annual Score %</h5>
                                <h3 class="text-white">{{ intval($correctedAnnualAverage) }}%</h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-6">
                        <div class="card text-center bg-info">
                            <div class="card-body">
                                <h5 class="card-title text-white">Sessions</h5>
                                <h3 class="text-white">{{ $studentData['session_count'] }}</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div
                            class="card text-center {{ $promotionStatus['is_promoted'] ? 'bg-success' : 'bg-danger' }}">
                            <div class="card-body">
                                <h5 class="card-title text-white">Comment</h5>
                                <h3 class="text-white">{{ $promotionStatus['comment'] }}</h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Grade Distribution -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0" style="color: var(--primary-color);">Annual Grade Distribution</h6>
                    </div>
                    <div class="card-body">
                        <div class="row text-center g-2">
                            @foreach(['A', 'B', 'C', 'D', 'E', 'F'] as $grade)
                                <div class="col-6 col-sm-4 col-md-2">
                                    <div
                                        class="badge bg-{{ $grade === 'A' ? 'success' : ($grade === 'F' ? 'danger' : 'secondary') }} p-3 w-100 d-flex flex-column align-items-center justify-content-center"
                                        style="min-height: 60px;">
                                        <div class="fw-bold">{{ $grade }}</div>
                                        <div class="h6 mb-0">{{ $studentData['annual_grades'][$grade] }}</div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Session-wise Results -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0" style="color: var(--primary-color);">Session-wise Results</h6>
                    </div>
                    <div class="card-body">
                        <!-- Desktop View -->
                        <div class="d-none d-lg-block">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped text-center align-middle">
                                    <thead class="table-dark">
                                    <tr>
                                        <th rowspan="2">Subject</th>
                                        @foreach($sessions as $session)
                                            <th colspan="4" class="text-center">{{ $session->name }}</th>
                                        @endforeach
                                    </tr>
                                    <tr>
                                        @foreach($sessions as $session)
                                            <th>CA</th>
                                            <th>Exam</th>
                                            <th>Total</th>
                                            <th>Grade</th>
                                        @endforeach
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($subjects as $subject)
                                        <tr>
                                            <td class="text-start"><strong>{{ $subject->display_name }}</strong></td>
                                            @foreach($sessions as $session)
                                                @php
                                                    $result = $studentData['sessions'][$session->id]['subjects'][$subject->id] ?? null;
                                                @endphp
                                                <td>{{ is_numeric($result['ca_score'] ?? 0) ? intval($result['ca_score']) : ($result['ca_score'] ?? 0) }}</td>
                                                <td>{{ is_numeric($result['exam_score'] ?? 0) ? intval($result['exam_score']) : ($result['exam_score'] ?? 0) }}</td>
                                                <td>
                                                    <strong>{{ is_numeric($result['total'] ?? 0) ? intval($result['total']) : ($result['total'] ?? 0) }}</strong>
                                                </td>
                                                <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['grade'] ?? 'F') }}</td>
                                            @endforeach
                                        </tr>
                                    @endforeach
                                    <tr class="table-info">
                                        <td class="text-start"><strong>Session Total</strong></td>
                                        @foreach($sessions as $session)
                                            <td></td>
                                            <td></td>
                                            @php
                                                $sessionMaxTotal = app('App\Services\AnnualResultService')->calculateSessionMaxTotal($session->id, $subjects, $studentData);
                                            @endphp
                                            <td>
                                                <strong>{{ intval($studentData['sessions'][$session->id]['grand_total']) }}
                                                    /{{ intval($sessionMaxTotal) }}</strong></td>
                                            <td></td>
                                        @endforeach
                                    </tr>
                                    <tr class="table-warning">
                                        <td class="text-start"><strong>Session Average</strong></td>
                                        @foreach($sessions as $session)
                                            <td></td>
                                            <td></td>
                                            <td>
                                                <strong>{{ intval($studentData['sessions'][$session->id]['average']) }}</strong>
                                            </td>
                                            <td></td>
                                        @endforeach
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Mobile View -->
                        <div class="d-lg-none">
                            @foreach($sessions as $index => $session)
                                <div class="card mb-2">
                                    <div class="card-header p-0">
                                        <div class="d-flex">
                                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse"
                                                 data-bs-target="#session{{ $index }}" style="cursor: pointer;">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <span
                                                            class="badge bg-light text-dark me-2">{{ $index + 1 }}</span>
                                                        <strong>{{ $session->name }}</strong>
                                                    </div>
                                                    <div>
                                                        <i class="fas fa-chevron-down text-muted"
                                                           style="transform: rotate(0deg); transition: transform 0.3s ease;"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse" id="session{{ $index }}">
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <div class="d-flex flex-wrap gap-2 mb-2">
                                                    <span
                                                        class="badge bg-primary">Total: {{ intval($studentData['sessions'][$session->id]['grand_total']) }}</span>
                                                    <span
                                                        class="badge bg-success">Average: {{ intval($studentData['sessions'][$session->id]['average']) }}</span>
                                                </div>
                                            </div>

                                            <div class="table-responsive">
                                                <table class="table table-sm">
                                                    <thead>
                                                    <tr>
                                                        <th>Subject</th>
                                                        <th>CA</th>
                                                        <th>Exam</th>
                                                        <th>Total</th>
                                                        <th>Grade</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($subjects as $subject)
                                                        @php
                                                            $result = $studentData['sessions'][$session->id]['subjects'][$subject->id] ?? null;
                                                        @endphp
                                                        <tr>
                                                            <td>{{ $subject->display_name }}</td>
                                                            <td>{{ is_numeric($result['ca_score'] ?? 0) ? intval($result['ca_score']) : ($result['ca_score'] ?? 0) }}</td>
                                                            <td>{{ is_numeric($result['exam_score'] ?? 0) ? intval($result['exam_score']) : ($result['exam_score'] ?? 0) }}</td>
                                                            <td>
                                                                <strong>{{ is_numeric($result['total'] ?? 0) ? intval($result['total']) : ($result['total'] ?? 0) }}</strong>
                                                            </td>
                                                            <td>{{ app('App\Services\AnnualResultService')->formatResultValue($result['grade'] ?? 'F') }}</td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <!-- Assessment Traits -->
        @if(!empty($studentData) && isset($annualApproval))
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="mb-0" style="color: var(--primary-color);">Assessment Traits</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 style="color: var(--primary-color);">Affective Traits</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-bordered">
                                            <tbody>
                                            <tr>
                                                <td>Punctuality</td>
                                                <td class="text-center">{{ intval($annualApproval->punctuality ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Mental Alertness</td>
                                                <td class="text-center">{{ intval($annualApproval->mental_alertness ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Attentiveness</td>
                                                <td class="text-center">{{ intval($annualApproval->attentiveness ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Respect</td>
                                                <td class="text-center">{{ intval($annualApproval->respect ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Neatness</td>
                                                <td class="text-center">{{ intval($annualApproval->neatness ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Politeness</td>
                                                <td class="text-center">{{ intval($annualApproval->politeness ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Honesty</td>
                                                <td class="text-center">{{ intval($annualApproval->honesty ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Relationship with Peers</td>
                                                <td class="text-center">{{ intval($annualApproval->relationship_with_peers ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Attitude to School</td>
                                                <td class="text-center">{{ intval($annualApproval->attitude_to_school ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Teamwork</td>
                                                <td class="text-center">{{ intval($annualApproval->teamwork ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Completes School Work Promptly</td>
                                                <td class="text-center">{{ intval($annualApproval->completes_school_work_promptly ?? 4) }}</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h6 style="color: var(--primary-color);">Psychomotor Skills</h6>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-bordered">
                                            <tbody>
                                            <tr>
                                                <td>Reading</td>
                                                <td class="text-center">{{ intval($annualApproval->reading ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Verbal Fluency/Diction</td>
                                                <td class="text-center">{{ intval($annualApproval->verbal_fluency_diction ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Handwriting</td>
                                                <td class="text-center">{{ intval($annualApproval->handwriting ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Musical Skills</td>
                                                <td class="text-center">{{ intval($annualApproval->musical_skills ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Creative Arts</td>
                                                <td class="text-center">{{ intval($annualApproval->creative_arts ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>Physical Education</td>
                                                <td class="text-center">{{ intval($annualApproval->physical_education ?? 4) }}</td>
                                            </tr>
                                            <tr>
                                                <td>General Reasoning</td>
                                                <td class="text-center">{{ intval($annualApproval->general_reasoning ?? 4) }}</td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    @if(isset($annualApproval->principal_remarks))
                                        <div class="mt-3">
                                            <h6 style="color: var(--primary-color);">Head Teacher's Remarks</h6>
                                            <p class="border p-2 rounded">{{ $annualApproval->principal_remarks }}</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <!-- Teachers and Timestamp -->
        @if(settings('show_class_teachers_online', true) || settings('show_timestamp', true))
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                @if(settings('show_class_teachers_online', true))
                                    <div class="col-md-6">
                                        <h6>Class Teachers:</h6>
                                        @if($teachers && $teachers->count() > 0)
                                            @foreach($teachers as $teacher)
                                                <span class="badge bg-primary me-1">{{ $teacher->name }}</span>
                                            @endforeach
                                        @else
                                            <span class="text-muted">No teachers assigned</span>
                                        @endif
                                    </div>
                                @endif
                                @if(settings('show_timestamp', true))
                                    <div class="col-md-6 text-end">
                                        <small class="text-muted">Generated
                                            on: {{ now()->format('M d, Y \a\t h:i A') }}</small>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

        <!-- Print Button or Approval Message -->
        <div class="row mt-4">
            <div class="col-12 text-center">
                @if(isset($annualApproval))
                    <button
                        onclick="window.open('{{ route('results.print-student-annual', [$selectedStudent->student_id, $selectedYear]) }}', 'printWindow', 'width=1024,height=768,scrollbars=yes,resizable=yes,toolbar=no,menubar=no,location=no,status=no')"
                        class="btn btn-success btn-lg">
                        <i class="fas fa-print"></i> Print Annual Result
                    </button>
                @else
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"> </i> You cannot print this result because it has not
                        been approved! Please approve it or contact the Head Teacher or Administrator.
                    </div>
                @endif
            </div>
        </div>

    @endif
</div>

<script>
    document.addEventListener('livewire:initialized', () => {
        Livewire.on('initStudentGradeChart', (data) => {
            setTimeout(() => {
                if (typeof initGradeChart === 'function') {
                    initGradeChart('gradeChart', data[0].labels, data[0].data, 'Grade Distribution');
                }
            }, 100);
        });
    });

    // Handle chevron animation for session accordions
    document.addEventListener('click', function (e) {
        const trigger = e.target.closest('[data-bs-toggle="collapse"][data-bs-target^="#session"]');
        if (trigger) {
            const chevron = trigger.querySelector('.fa-chevron-down');

            if (chevron) {
                // Toggle based on current transform state
                const currentTransform = chevron.style.transform;
                if (currentTransform === 'rotate(180deg)') {
                    chevron.style.transform = 'rotate(0deg)';
                } else {
                    chevron.style.transform = 'rotate(180deg)';
                }
            }
        }
    });


</script>
