<div>
    <form wire:submit="save">
        <div class="row">
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="name" class="form-label">Class Name <span class="text-danger">*</span></label>
                    <input type="text" wire:model="name" class="form-control @error('name') is-invalid @enderror" 
                           id="name" placeholder="Enter class name">
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="alias" class="form-label">Alias</label>
                    <input type="text" wire:model="alias" class="form-control @error('alias') is-invalid @enderror" 
                           id="alias" placeholder="Enter class alias">
                    @error('alias')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="is_active" class="form-label">Status</label>
                    <select wire:model="is_active" class="form-select @error('is_active') is-invalid @enderror" id="is_active">
                        <option value="1">Active</option>
                        <option value="0">Inactive</option>
                    </select>
                    @error('is_active')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
        </div>

        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea wire:model="description" class="form-control @error('description') is-invalid @enderror" 
                      id="description" rows="3" placeholder="Enter class description (optional)"></textarea>
            @error('description')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="d-flex justify-content-end gap-2">
            <a href="{{ route('school-classes.index') }}" class="btn btn-secondary">
                <i class="fas fa-times"></i> Cancel
            </a>
            <button type="submit" class="btn btn-success">
                <i class="fas fa-save"></i> {{ $isEdit ? 'Update' : 'Create' }} Class
            </button>
        </div>
    </form>
</div>
