<div>
    <div class="mb-3">
        <p class="text-muted">Drag and drop classes to reorder them. Changes are saved automatically.</p>
    </div>

    <div id="sortable-classes" class="list-group">
        @foreach($classes as $class)
            <div class="list-group-item d-flex justify-content-between align-items-center" 
                 data-id="{{ $class['id'] }}" style="cursor: move;">
                <div class="d-flex align-items-center">
                    <i class="fas fa-grip-vertical text-muted me-3"></i>
                    <div>
                        <h6 class="mb-1">{{ $class['name'] }}</h6>
                        @if($class['alias'])
                            <small class="text-muted">Alias: {{ $class['alias'] }}</small>
                        @endif
                    </div>
                </div>
                <div class="d-flex align-items-center">
                    <span class="badge {{ $class['is_active'] ? 'bg-success' : 'bg-danger' }} me-2">
                        {{ $class['is_active'] ? 'Active' : 'Inactive' }}
                    </span>
                    <span class="badge bg-secondary">Order: {{ $class['order'] }}</span>
                </div>
            </div>
        @endforeach
    </div>

    @if(empty($classes))
        <div class="text-center py-4">
            <p class="text-muted">No classes available to reorder.</p>
        </div>
    @endif

    <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const sortableElement = document.getElementById('sortable-classes');
        if (sortableElement) {
            Sortable.create(sortableElement, {
                animation: 150,
                ghostClass: 'sortable-ghost',
                onEnd: function(evt) {
                    const orderedIds = Array.from(sortableElement.children).map(item => 
                        parseInt(item.getAttribute('data-id'))
                    );
                    @this.call('updateOrder', orderedIds);
                }
            });
        }
    });
    </script>

    <style>
    .sortable-ghost {
        opacity: 0.4;
    }
    .list-group-item:hover {
        background-color: #f8f9fa;
    }
    </style>
</div>
