<div>
    @if($classes->count() > 0)
        <div class="row mb-3">
            <div class="col-md-6">
                <input type="text" wire:model.live="search" class="form-control" placeholder="Search classes...">
            </div>
        </div>

        <!-- Desktop Table -->
        <div class="d-none d-lg-block">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Name</th>
                            <th>Alias</th>
                            <th>Description</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($classes as $class)
                            <tr>
                                <td>{{ $class->order }}</td>
                                <td>{{ $class->name }}</td>
                                <td>{{ $class->alias ?? 'N/A' }}</td>
                                <td>{{ $class->description ?? 'N/A' }}</td>
                                <td>
                                    <span class="badge {{ $class->is_active ? 'bg-success' : 'bg-danger' }}">
                                        {{ $class->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>
                                    <div class="d-flex gap-1">
                                        <a href="{{ route('school-classes.edit', $class) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button onclick="confirmToggleStatus({{ $class->id }}, {{ $class->is_active ? 'false' : 'true' }})" class="btn btn-sm btn-outline-warning">
                                            <i class="fas fa-toggle-{{ $class->is_active ? 'on' : 'off' }}"></i>
                                        </button>
                                        <button onclick="confirmDelete({{ $class->id }})" 
                                                class="btn btn-sm btn-outline-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Mobile Accordions -->
        <div class="d-lg-none">
            @foreach($classes as $index => $class)
                <div class="card mb-2">
                    <div class="card-header p-0">
                        <div class="d-flex">
                            <div class="flex-grow-1 p-3" data-bs-toggle="collapse"
                                 data-bs-target="#class{{ $class->id }}" style="cursor: pointer;">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong>{{ $class->name }}</strong>
                                        @if($class->alias)
                                            <span class="text-muted ms-2">|</span>
                                            <span class="ms-2">{{ $class->alias }}</span>
                                        @endif
                                        <span class="text-muted ms-2">|</span>
                                        <small class="text-muted ms-2">Order: {{ $class->order }}</small>
                                    </div>
                                    <div>
                                        <span class="badge {{ $class->is_active ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $class->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="p-3 border-start">
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary" type="button"
                                            data-bs-toggle="dropdown">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-sm">
                                        <li><a class="dropdown-item dropdown-item-sm"
                                               href="{{ route('school-classes.edit', $class) }}">
                                                <i class="fas fa-edit me-2"></i>Edit
                                            </a></li>
                                        <li>
                                            <button
                                                class="dropdown-item dropdown-item-sm text-{{ $class->is_active ? 'warning' : 'success' }}"
                                                onclick="confirmToggleStatus({{ $class->id }}, {{ $class->is_active ? 'false' : 'true' }})">
                                                <i class="fas fa-{{ $class->is_active ? 'pause' : 'play' }} me-2"></i>{{ $class->is_active ? 'Deactivate' : 'Activate' }}
                                            </button>
                                        </li>
                                        <li>
                                            <hr class="dropdown-divider">
                                        </li>
                                        <li>
                                            <button class="dropdown-item dropdown-item-sm text-danger"
                                                    onclick="confirmDelete({{ $class->id }})">
                                                <i class="fas fa-trash me-2"></i>Delete
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="collapse" id="class{{ $class->id }}">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Name:</strong> {{ $class->name }}</p>
                                    <p><strong>Alias:</strong> {{ $class->alias ?? 'N/A' }}</p>
                                    <p><strong>Order:</strong> {{ $class->order }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Status:</strong>
                                        <span class="badge {{ $class->is_active ? 'bg-success' : 'bg-secondary' }}">
                                            {{ $class->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </p>
                                    <p><strong>Created:</strong> {{ $class->created_at->format('M d, Y') }}</p>
                                </div>
                            </div>
                            @if($class->description)
                                <hr>
                                <p><strong>Description:</strong> {{ $class->description }}</p>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="mt-3">
            {{ $classes->links() }}
        </div>
    @else
        <div class="card border-0 shadow-sm">
            <div class="card-body text-center py-5">
                <i class="fas fa-school fa-3x text-muted mb-3"></i>
                <h4 class="fw-bold mb-3">No Classes Found</h4>
                <p class="text-muted mb-4">You haven't created any classes yet. Get started by adding your first class.</p>
                <a href="{{ route('school-classes.create') }}" class="btn btn-success">
                    <i class="fas fa-plus"></i> Create First Class
                </a>
            </div>
        </div>
    @endif
</div>

<script>
function confirmDelete(classId) {
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: 'var(--primary-color)',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            @this.call('deleteClass', classId);
        }
    });
}

function confirmToggleStatus(classId, newStatus) {
    const action = newStatus === 'true' ? 'activate' : 'deactivate';
    Swal.fire({
        title: `${action.charAt(0).toUpperCase() + action.slice(1)} Class?`,
        text: `Are you sure you want to ${action} this class?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: 'var(--primary-color)',
        cancelButtonColor: '#6c757d',
        confirmButtonText: `Yes, ${action} it!`
    }).then((result) => {
        if (result.isConfirmed) {
            @this.call('toggleStatus', classId);
        }
    });
}
</script>
